% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{gr_kable_tests}
\alias{gr_kable_tests}
\title{Tabular representation of tests}
\usage{
gr_kable_tests(tests, format = "html")
}
\arguments{
\item{tests}{\code{list} of tests as returned by \code{\link[=gr_test_vars]{gr_test_vars()}} function.}

\item{format}{Character string encoding the type of output. Currently \code{'html'} only is supported.}
}
\value{
HTML table as returned by \code{\link[knitr:kable]{knitr::kable()}} function.
}
\description{
This function is used to represent the results of \code{\link[=gr_test_vars]{gr_test_vars()}} in a tabular form. Used mainly in \code{\link[=gr_report]{gr_report()}}, but can be used for your own purposes.
}
\examples{
if (require("kableExtra")) {
  
  library(grwat)
  
  data(spas) # example Spas-Zagorye data is included with grwat package
  
  # separate
  sep = gr_separate(spas, params = gr_get_params(reg = 'center'))
  
  # summarize from 1965 to 1990
  vars = gr_summarize(sep, 1965, 1990)
  
  # test all variables
  tests = gr_test_vars(vars)
  
  # kable tests
  gr_kable_tests(tests)

}
}
