% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_functions.R
\name{sobol_fun}
\alias{sobol_fun}
\title{Sobol G function evaluation}
\usage{
sobol_fun(N, a = c(0, 1, 4.5, 9, 99, 99, 99, 99))
}
\arguments{
\item{N}{Integer. Number of input samples to generate.}

\item{a}{(default: \code{c(0, 1, 4.5, 9, 99, 99, 99, 99)}) Numeric vector of non-negative parameters of length 8.
These parameters control the sensitivity of each input dimension.}
}
\value{
A list with two elements:
\itemize{
\item \code{x}: a numeric matrix of size \code{N x 8} containing the input samples.
\item \code{y}: a numeric vector of length \code{N} with the corresponding function outputs.
}
}
\description{
This function evaluates the Sobol G function on a set of input samples
generated via crude Monte Carlos. It returns both the sampled
inputs and the corresponding function outputs.
}
\details{
The Sobol G function is defined as:
\deqn{
  Y = \prod_{j=1}^{8} \frac{|\ 4 X_j - 2\ | + a_j}{1 + a_j}
}
where \eqn{X_j \sim \mathcal{U}(0, 1)} independently.
}
\examples{
result <- sobol_fun(1000)
head(result$x)
head(result$y)

}
\seealso{
\code{\link{ishi_homma_fun}}, \code{\link{gaussian_fun}}
}
