% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.r
\name{h5_exists}
\alias{h5_exists}
\title{Check if an HDF5 File, Object, or Attribute Exists}
\usage{
h5_exists(file, name = "/", attr = NULL, assert = FALSE)
}
\arguments{
\item{file}{Path to the file.}

\item{name}{The full path of the object to check (e.g., \code{"/data/matrix"}).
Defaults to \code{"/"} to test file validity.}

\item{attr}{The name of an attribute to check. If provided, the function tests
for the existence of this attribute on \code{name}.}

\item{assert}{Logical. If \code{TRUE} and the target does not exist, the function
will stop with an informative error message instead of returning \code{FALSE}.
Defaults to \code{FALSE}.}
}
\value{
A logical value: \code{TRUE} if the target exists and is valid, \code{FALSE} otherwise.
}
\description{
Safely checks if a file, an object within a file, or an attribute on an object exists.
}
\details{
This function provides a robust, error-free way to test for existence.

\itemize{
\item \strong{Testing for a File:} If \code{name} is \code{/} and \code{attr} is \code{NULL},
the function checks if \code{file} is a valid, readable HDF5 file.

\item \strong{Testing for an Object:} If \code{name} is a path (e.g., \verb{/data/matrix})
and \code{attr} is \code{NULL}, the function checks if the specific object exists.

\item \strong{Testing for an Attribute:} If \code{attr} is provided, the function checks
if that attribute exists on the specified object \code{name}.
}
}
\examples{
file <- tempfile(fileext = ".h5")

h5_exists(file) # FALSE

h5_create_file(file)
h5_exists(file) # TRUE

h5_exists(file, "missing_object") # FALSE

h5_write(1:10, file, "my_ints")
h5_exists(file, "my_ints") # TRUE

h5_exists(file, "my_ints", "missing_attr") # FALSE

h5_write(1:10, file, "my_ints", attr = "my_attr")
h5_exists(file, "my_ints", "my_attr") # TRUE

unlink(file)
}
\seealso{
\code{\link[=h5_is_group]{h5_is_group()}}, \code{\link[=h5_is_dataset]{h5_is_dataset()}}
}
