% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info.r
\name{h5_names}
\alias{h5_names}
\title{Get Names of an HDF5 Object}
\usage{
h5_names(file, name = "/", attr = NULL)
}
\arguments{
\item{file}{The path to the HDF5 file.}

\item{name}{The full path of the object.}

\item{attr}{The name of an attribute. If provided, returns the names associated with the attribute
(e.g., field names if the attribute is a compound type). (Default: \code{NULL})}
}
\value{
A character vector of names, or \code{NULL} if the object has no names.
}
\description{
Returns the names of the object.
\itemize{
\item For \strong{Groups}, it returns the names of the objects contained in the group (similar to \code{ls()}).
\item For \strong{Compound Datasets} (data.frames), it returns the column names.
\item For other \strong{Datasets}, it looks for a dimension scale and returns it if found.
}
}
\examples{
file <- tempfile(fileext = ".h5")

h5_write(data.frame(x=1, y=2), file, "df")
h5_names(file, "df") # "x" "y"

x <- 1:5
names(x) <- letters[1:5]
h5_write(x, file, "x")
h5_names(file, "x") # "a" "b" "c" "d" "e"

h5_write(mtcars[,c("mpg", "hp")], file, "dset")
h5_names(file, "dset") # "mpg" "hp"

unlink(file)
}
