% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MTDest-methods.R
\name{MTDest-methods}
\alias{MTDest-methods}
\title{Methods for objects of class \code{"MTDest"}}
\arguments{
\item{x}{An object of class \code{"MTDest"} (for \code{print.MTDest(x, ...)}).}

\item{object}{An object of class \code{"MTDest"}.}

\item{...}{Further arguments passed to or from other methods (ignored).}
}
\value{
\describe{
\item{\code{print.MTDest}}{Invisibly returns the \code{"MTDest"} object, after
displaying its lag set, state space, final log-likelihood, and iteration
count (if available).}
\item{\code{summary.MTDest}}{Invisibly returns a named list with fields:
\code{call}, \code{S}, \code{A}, \code{lambdas}, \code{pj},
\code{p0} (or \code{NULL}),\code{logLik}, \code{oscillations},
\code{iterations}, \code{lastComputedDelta} and \code{deltaLogLik}.
The same information is printed to the console in a readable format.}
\item{\code{logLik.MTDest}}{ An object of class \code{"logLik"} with attributes
\code{df} (number of free parameters) and \code{nobs} (effective sample size).}
}
}
\description{
Methods for objects returned by \code{MTDest()} – EM fits of Mixture Transition
Distribution models. Note that \code{"MTDest"} objects inherit from class \code{"MTD"}
(they have class \code{c("MTDest", "MTD")}), and several methods for \code{"MTD"}
also work on \code{"MTDest"} objects by inheritance. The methods documented
here are specific to EM fits, providing diagnostics and summaries of the estimation.
}
\details{
These methods handle objects returned by \code{\link{MTDest}} (class \code{c("MTDest","MTD")}):
\itemize{
\item \code{print.MTDest()} displays a compact summary of the fitted model:
the lag set (\code{S}), the state space (\code{A}), the final
log-likelihood, and, if available, the number of EM updates performed.

\item \code{summary.MTDest()} computes and prints a detailed summary of the
key components of the object, including lambdas, transition matrices,
independent distribution (if present), log-likelihood, and
(if available) oscillations and iteration diagnostics.

\item \code{logLik.MTDest()} returns the log-likelihood as an object of class
\code{"logLik"}, with attributes \code{df} (number of free parameters
under the multimatrix model) and \code{nobs} (effective sample size).
}
}
\examples{
\dontrun{
set.seed(1)
MTD <- MTDmodel(Lambda = c(1, 3), A = c(0, 1), lam0 = 0.01)
X <- perfectSample(MTD, N = 200)  # small N to keep examples fast
init <- list(
  p0 = c(0.4, 0.6),
  lambdas = c(0.05, 0.45, 0.5),
  pj = list(
    matrix(c(0.2, 0.8, 0.45, 0.55), byrow = TRUE, ncol = 2),
    matrix(c(0.25, 0.75, 0.3, 0.7),  byrow = TRUE, ncol = 2)
  )
)
fit <- MTDest(X, S = c(1, 3), init = init, iter = TRUE)
print(fit)
summary(fit)
coef(fit) # Works by inheritance
logLik(fit)
BIC(fit)
}

}
\seealso{
\code{\link{MTDest}}, \code{\link{as.MTD}}, \code{\link{MTD-methods}},
\code{\link{oscillation}}, \code{\link{perfectSample}}, \code{\link{probs}}
}
