/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5FSmodule.h" 
#define H5FS_TESTING    

#include "H5private.h"  
#include "H5Eprivate.h" 
#include "H5FSpkg.h"    

herr_t
H5FS__get_cparam_test(const H5FS_t *frsp, H5FS_create_t *cparam)
{
    FUNC_ENTER_PACKAGE_NOERR

    
    assert(frsp);
    assert(cparam);

    cparam->client         = frsp->client;
    cparam->shrink_percent = frsp->shrink_percent;
    cparam->expand_percent = frsp->expand_percent;
    cparam->max_sect_addr  = frsp->max_sect_addr;
    cparam->max_sect_size  = frsp->max_sect_size;

    FUNC_LEAVE_NOAPI(SUCCEED)
} 

int
H5FS__cmp_cparam_test(const H5FS_create_t *cparam1, const H5FS_create_t *cparam2)
{
    int ret_value = 0; 

    FUNC_ENTER_PACKAGE_NOERR

    
    assert(cparam1);
    assert(cparam2);

    if (cparam1->client < cparam2->client)
        HGOTO_DONE(-1);
    else if (cparam1->client > cparam2->client)
        HGOTO_DONE(1);

    if (cparam1->shrink_percent < cparam2->shrink_percent)
        HGOTO_DONE(-1);
    else if (cparam1->shrink_percent > cparam2->shrink_percent)
        HGOTO_DONE(1);

    if (cparam1->expand_percent < cparam2->expand_percent)
        HGOTO_DONE(-1);
    else if (cparam1->expand_percent > cparam2->expand_percent)
        HGOTO_DONE(1);

    if (cparam1->max_sect_size < cparam2->max_sect_size)
        HGOTO_DONE(-1);
    else if (cparam1->max_sect_size > cparam2->max_sect_size)
        HGOTO_DONE(1);

    if (cparam1->max_sect_addr < cparam2->max_sect_addr)
        HGOTO_DONE(-1);
    else if (cparam1->max_sect_addr > cparam2->max_sect_addr)
        HGOTO_DONE(1);

done:
    FUNC_LEAVE_NOAPI(ret_value)
} 
