/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5HLmodule.h" 

#include "H5private.h"   
#include "H5Eprivate.h"  
#include "H5FLprivate.h" 
#include "H5HLpkg.h"     

H5FL_DEFINE_STATIC(H5HL_prfx_t);

H5HL_prfx_t *
H5HL__prfx_new(H5HL_t *heap)
{
    H5HL_prfx_t *prfx      = NULL; 
    H5HL_prfx_t *ret_value = NULL;

    FUNC_ENTER_PACKAGE

    
    assert(heap);

    
    if (NULL == (prfx = H5FL_CALLOC(H5HL_prfx_t)))
        HGOTO_ERROR(H5E_HEAP, H5E_CANTALLOC, NULL, "memory allocation failed for local heap prefix");

    
    if (FAIL == H5HL__inc_rc(heap))
        HGOTO_ERROR(H5E_HEAP, H5E_CANTINC, NULL, "can't increment heap ref. count");

    
    prfx->heap = heap;
    heap->prfx = prfx;

    
    ret_value = prfx;

done:
    
    if (!ret_value && prfx != NULL)
        
        prfx = H5FL_FREE(H5HL_prfx_t, prfx);

    FUNC_LEAVE_NOAPI(ret_value)
} 

herr_t
H5HL__prfx_dest(H5HL_prfx_t *prfx)
{
    herr_t ret_value = SUCCEED;

    FUNC_ENTER_PACKAGE

    
    assert(prfx);

    
    if (prfx->heap) {
        
        prfx->heap->prfx = NULL;

        
        if (FAIL == H5HL__dec_rc(prfx->heap))
            HGOTO_ERROR(H5E_HEAP, H5E_CANTDEC, FAIL, "can't decrement heap ref. count");

        
        prfx->heap = NULL;
    }

done:
    
    
    prfx = H5FL_FREE(H5HL_prfx_t, prfx);

    FUNC_LEAVE_NOAPI(ret_value)
} 
