/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5Pmodule.h" 

#include "H5private.h"  
#include "H5Mprivate.h" 
#include "H5Eprivate.h" 
#include "H5Ppkg.h"     

static herr_t H5P__mcrt_reg_prop(H5P_genclass_t *pclass);

const H5P_libclass_t H5P_CLS_MCRT[1] = {{
    "map create",        
    H5P_TYPE_MAP_CREATE, 

    &H5P_CLS_OBJECT_CREATE_g, 
    &H5P_CLS_MAP_CREATE_g,    
    &H5P_CLS_MAP_CREATE_ID_g, 
    &H5P_LST_MAP_CREATE_ID_g, 
    H5P__mcrt_reg_prop,       

    NULL, 
    NULL, 
    NULL, 
    NULL, 
    NULL, 
    NULL  
}};

static herr_t
H5P__mcrt_reg_prop(H5P_genclass_t H5_ATTR_UNUSED *pclass)
{
    herr_t ret_value = SUCCEED; 

    FUNC_ENTER_PACKAGE_NOERR

    FUNC_LEAVE_NOAPI(ret_value)
} 
