% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cholesky}
\alias{cholesky}
\title{Efficient Cholesky decomposition}
\usage{
cholesky(A)
}
\arguments{
\item{A}{matrix to decompose}
}
\value{
upper triangular matrix R such that A = U'U.
}
\description{
Compute Cholesky decomposition of a matrix.
}
\examples{
# Larger example
set.seed(123)
B <- matrix(rnorm(16), 4, 4)
B <- t(B) \%*\% B  # Make symmetric positive definite
U <- cholesky(B)
U
# Verify decomposition
all.equal(B, t(U) \%*\% U)
}
\seealso{
\code{\link[=harmonicHMC]{harmonicHMC()}}
}
