% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attribute_health.R
\name{attribute_health}
\alias{attribute_health}
\title{Attribute health impacts to an environmental stressor}
\usage{
attribute_health(
  approach_risk = "relative_risk",
  exp_central,
  exp_lower = NULL,
  exp_upper = NULL,
  cutoff_central = 0,
  cutoff_lower = NULL,
  cutoff_upper = NULL,
  pop_exp = NULL,
  erf_eq_central = NULL,
  erf_eq_lower = NULL,
  erf_eq_upper = NULL,
  rr_central = NULL,
  rr_lower = NULL,
  rr_upper = NULL,
  rr_increment = NULL,
  erf_shape = NULL,
  bhd_central = NULL,
  bhd_lower = NULL,
  bhd_upper = NULL,
  prop_pop_exp = 1,
  geo_id_micro = "a",
  geo_id_macro = NULL,
  age_group = "all",
  sex = "all",
  dw_central = NULL,
  dw_lower = NULL,
  dw_upper = NULL,
  duration_central = NULL,
  duration_lower = NULL,
  duration_upper = NULL,
  info = NULL,
  population = NULL
)
}
\arguments{
\item{approach_risk}{\code{String value} specifying the \strong{risk method}. Options: \code{"relative_risk"} (default) or \code{"absolute_risk"}.}

\item{exp_central, exp_lower, exp_upper}{\code{Numeric value} or \code{numeric vector} specifying the \strong{exposure level(s)} to the environmental stressor and (optionally) the corresponding lower and upper bound of the 95\% confidence interval. See Details for more info.}

\item{cutoff_central, cutoff_lower, cutoff_upper}{\code{Numeric value} specifying the \strong{exposure cut-off value} and (optionally) the corresponding lower and upper 95\% confidence interval bounds. Default: 0. See Details for more info.}

\item{pop_exp}{\code{Numeric vector} specifying the absolute size of the \strong{population(s) exposed} to each exposure category. See Details for more info. \emph{Only applicable in AR pathways; always required.}}

\item{erf_eq_central, erf_eq_lower, erf_eq_upper}{\code{String} or \code{function} specifying the \strong{exposure-response function} and (optionally) the corresponding lower and upper 95\% confidence interval functions. See Details for more info. \emph{Required in AR pathways; in RR pathways required only if \code{rr_...} argument(s) not specified.}}

\item{rr_central, rr_lower, rr_upper}{\code{Numeric value} specifying the \strong{central relative risk} estimate and (optionally) the corresponding lower and upper 95\% confidence interval bounds. \emph{Only applicable in RR pathways; not required if \code{erf_eq_...} argument(s) already specified.}}

\item{rr_increment}{\code{Numeric value} specifying the \strong{exposure increment} for which the provided relative risk is valid. See Details for more info. \emph{Only applicable in RR pathways; not required if \code{erf_eq_...} argument(s) already specified.}}

\item{erf_shape}{\code{String value} specifying the \strong{exposure-response function shape} to be assumed. Options (no default): \code{"linear"}, \code{log_linear}", \code{"linear_log"}, \code{"log_log"}. \emph{Only applicable in RR pathways; not required if \code{erf_eq_...} argument(s) already specified.}}

\item{bhd_central, bhd_lower, bhd_upper}{\code{Numeric value} or \code{numeric vector} providing the \strong{baseline health data} of the health outcome of interest in the study population and (optionally) the corresponding lower bound and the upper 95\% confidence interval bounds. See Details for more info. \emph{Only applicable in RR pathways; always required.}}

\item{prop_pop_exp}{\code{Numeric value} or \code{numeric vector} specifying the \strong{population fraction(s) exposed} for each exposure (category). Default: 1. See Details for more info. \emph{Only applicable in RR pathways.}}

\item{geo_id_micro, geo_id_macro}{\code{Numeric vector} or \code{string vector} providing \strong{unique IDs of the geographic area} considered in the assessment (\code{geo_id_micro}) and (optionally) providing higher-level IDs (\code{geo_id_macro}) to aggregate the geographic areas at. See Details for more info. \emph{Only applicable in assessments with multiple geographic units.}}

\item{age_group}{\code{Numeric vector} or \code{string vector} providing the \strong{age groups} considered in the assessment. In case of use in \code{attribute_lifetable)()}, it must be a \code{numeric} and contain single year age groups. See Details for more info. \emph{Optional argument for \code{attribute_health()}; needed for \code{attribute_lifetable()}.}}

\item{sex}{\code{Numeric vector} or \code{string vector} specifying the \strong{sex} of the groups considered in the assessment.\emph{Optional argument.}}

\item{dw_central, dw_lower, dw_upper}{\code{Numeric value} or \code{numeric vector} providing the \strong{disability weight} associated with the morbidity health outcome of interest and (optionally) the corresponding lower bound and the upper 95\% confidence interval bounds. \emph{Only applicable in assessments of YLD (years lived with disability).}}

\item{duration_central, duration_lower, duration_upper}{\code{Numeric value} or \code{numeric vector} providing the \strong{duration} associated with the morbidity health outcome of interest in years and (optionally) the corresponding lower and upper bounds of the 95\% confidence interval. Default: 1. See Details for more info. \emph{Only applicable in assessments of YLD (years lived with disability).}}

\item{info}{\code{String}, \code{data frame} or \code{tibble} providing \strong{information about the assessment}. See Details for more info. \emph{Optional argument.}}

\item{population}{\code{Numeric vector} \strong{\code{For attribute_lifetable()}}, it is an \emph{obligatory argument} specifying the \strong{mid-year populations} per age (i.e. age group size = 1 year) for the (first) year of analysis.
\strong{\code{For attribute_health()}} it is an \emph{optional argument} which specifies the \strong{population used to calculate attributable impacts rate} per 100 000 population. See Details for more info.}
}
\value{
This function returns a \code{list} containing:

1) \code{health_main} (\code{tibble}) containing the main results;
\itemize{
 \item \code{impact} (\code{numeric} column) attributable health burden/impact
 \item \code{pop_fraction} (\code{numeric} column) population attributable fraction; only applicable in relative risk assessments
 \item And many more
}

2) \code{health_detailed} (\code{list}) containing detailed (and interim) results.
\itemize{
 \item \code{input_args} (\code{list}) containing all the argument inputs used in the background
 \item \code{input_table} (\code{tibble}) containing the inputs after preparation
 \item \code{results_raw} (\code{tibble}) containing results for all combinations of input (geo units, uncertainty, age and sex specific data...)
 \item \code{results_by_...} (\code{tibble}) containing results stratified by each geographic unit, age or sex.


}
}
\description{
This function calculates the attributable health impacts (mortality or morbidity) due to
exposure to an environmental stressor (air pollution or noise), using either relative risk (\strong{RR}) or absolute risk (\strong{AR}).

Arguments for both \strong{RR & AR} pathways
\itemize{
 \item \code{approach_risk}
 \item \code{exp_central}, \code{exp_lower}, \code{exp_upper}
 \item \code{cutoff_central}, \code{cutoff_lower}, \code{cutoff_upper}
 \item \code{erf_eq_central}, \code{erf_eq_lower}, \code{erf_eq_upper}
 }

Arguments only for \strong{RR} pathways
\itemize{
 \item \code{rr_central}, \code{rr_lower}, \code{rr_upper}
 \item \code{rr_increment}
 \item \code{erf_shape}
 \item \code{bhd_central}, \code{bhd_lower}, \code{bhd_upper}
 \item \code{prop_pop_exp}
 }

 Argument for \strong{AR} pathways
\itemize{
 \item \code{pop_exp}
 }

 \strong{Optional} arguments for both \strong{RR & AR} pathways
\itemize{
 \item \code{geo_id_micro}, \code{geo_id_macro},
 \item \code{age_group}, \code{sex}, \code{info}, \code{population}
 \item \code{dw_central}, \code{dw_lower}, \code{dw_upper}
 \item \code{duration_central}, \code{duration_lower}, \code{duration_upper}
 }
}
\details{
\strong{What you put in is what you get out}

The health metric you put in (e.g. absolute disease cases, deaths per 100 000 population, DALYs, prevalence, incidence, ...) is the one you get out.

\emph{Exception}: if you enter a disability weight (via the \code{dw_...} arguments) the attributable impact will be in YLD.


\strong{Function arguments}

\code{exp_central}, \code{exp_lower}, \code{exp_upper}
In case of exposure bands enter only one exposure value per band (e.g. the means of the lower and upper bounds of the exposure bands).

\code{cutoff_central}, \code{cutoff_lower}, \code{cutoff_upper}
The cutoff level refers to the exposure level below which no health effects occur in the same unit as the exposure. If exposure categories are used, the length of this input must be the same as in the \code{exp_...} argument(s).

\code{pop_exp}
\emph{Only applicable in AR pathways; always required.} In AR pathways the population exposed per exposure category is multiplied with the corresonding category-specific risk to obtain the absolute number of people affected by the health outcome.

\code{erf_eq_central}, \code{erf_eq_lower}, \code{erf_eq_upper}
\emph{Required in AR pathways; in RR pathways required only if rr_... arguments not specified.} Enter the exposure-response function as a \code{function}, e.g. output from \code{stats::splinefun()} or \code{stats::approxfun()}, or as a \code{string} formula, e.g. \code{"3+c+c^2"} (with the \emph{c} representing the concentration/exposure).
If you have x-axis (exposure) and y-axis (relative risk) value pairs of multiple points lying on the the exposure-response function, you could use e.g. \code{stats::splinefun(x, y, method="natural")} to derive the exposure-response function (in this example using a cubic spline natural interpolation).
\code{rr_increment}
\emph{Only applicable in RR pathways.} Relative risks from the literature are valid for a specific increment in the exposure, in case of air pollution often 10 or 5 \eqn{\mu g/m^3}).

\code{bhd_central}, \code{bhd_lower}, \code{bhd_upper}
\emph{Only applicable in RR pathways.} Baseline health data for each exposure category must be entered.

\code{prop_pop_exp}
\emph{Only applicable in RR pathways.} In RR pathways indicates the fraction(s) (value(s) from 0 until and including 1) of the total population exposed to the exposure categories. See equation of the population attributable fraction for categorical exposure below.

\code{geo_id_macro}, \code{geo_id_micro}
\emph{Only applicable in assessments with multiple geographic units.} For example, if you provide the names of the municipalities under analysis to \code{geo_id_micro}, you might provide to \code{geo_id_macro} the corresponding region / canton / province names.
Consequently, the vectors fed to \code{geo_id_micro} and \code{geo_id_macro} must be of the same length.

\code{age_group}
Can be either \code{numeric} or \code{character}. If it is numeric, it refers to the first age of the age group. E.g. \code{c(0, 40, 80)} means age groups \code{[0, 40), [40, 80), >=80]}.

\code{info}
\emph{Optional argument.} Information entered to this argument will be added as column(s) names \code{info_1}, \code{info_2}, \code{info_...} to the results table. These additional columns can be used to further stratify the analysis in a secondary step (see example below).

\code{population}
\emph{Optional argument.} The population entered here is used to determine impact rate per 100 000 population. Note the requirement for the vector length in the paragraph \emph{Assessment of multiple geographic units} below.

\code{duration_central}, \code{duration_lower}, \code{duration_upper}
\emph{Only applicable in assessments of YLD (years lived with disability).} Measured in years. A value of 1 (year) refers to the prevalence-based approach, while values above 1 to the incidence-based approach.


\strong{Methodology}

This function can quantify the attributable health impacts by means of a
relative risk or an absolute risk (depending on the health outcome).
\itemize{
 \item{Relative risk: The comparative risk assessment approach
 \insertCite{Murray2003_e}{healthiar} is applied by
obtaining the population attributable fraction
(percent of cases that are attributable to the exposure)
based on the relative risk \insertCite{WHO2003_report,Steenland2006-e,GBD2020_tl,Soares2020_report,Pozzer2023_gh,Lehtomaki_2025_eh}{healthiar}. }
 \item{Absolute risk: The attributable cases are
 directly derived from population exposed \insertCite{WHO2011_report}{healthiar}.}
 }

Detailed information about the methodology (including equations)
is available in the package vignette.
More specifically, see chapters:
\itemize{
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#relative-risk}{Relative risk}
 \item \href{https://swisstph.github.io/healthiar/articles/intro_to_healthiar.html#absolute-risk}{Absolute risk}}
}
\examples{
# Goal: attribute lung cancer cases to population-weighted PM2.5 exposure
# using relative risk

results <- attribute_health(
  erf_shape = "log_linear",
  rr_central = 1.369,            # Central relative risk estimate
  rr_increment = 10,             # per \\mu g / m^3 increase in PM2.5 exposure
  exp_central = 8.85,            # Central exposure estimate in \\mu g / m^3
  cutoff_central = 5,            # \\mu g / m^3
  bhd_central = 30747            # Baseline health data: lung cancer incidence
 )

results$health_main$impact_rounded # Attributable cases


# Goal: attribute cases of high annoyance to (road traffic) noise exposure
# using absolute risk

results <- attribute_health(
  approach_risk = "absolute_risk",
  exp_central = c(57.5, 62.5, 67.5, 72.5, 77.5),
  pop_exp = c(387500, 286000, 191800, 72200, 7700),
  erf_eq_central = "78.9270-3.1162*c+0.0342*c^2"
)

results$health_main$impact_rounded # Attributable high annoyance cases


# Goal: attribute disease cases to PM2.5 exposure in multiple geographic
# units, such as municipalities, provinces, countries, ...

results <- attribute_health(
  geo_id_micro = c("Zurich", "Basel", "Geneva", "Ticino"),
  geo_id_macro = c("Ger","Ger","Fra","Ita"),
  rr_central = 1.369,
  rr_increment = 10,
  cutoff_central = 5,
  erf_shape = "log_linear",
  exp_central = c(11, 11, 10, 8),
  bhd_central = c(4000, 2500, 3000, 1500)
)

# Attributable cases (aggregated)
results$health_main$impact_rounded

# Attributable cases (disaggregated)
results$health_detailed$results_raw |> dplyr::select(
  geo_id_micro,
  geo_id_macro,
  impact_rounded
)


# Goal: determine attributable YLD (years lived with disability)
results  <- attribute_health(
  exp_central = 8.85,
  prop_pop_exp = 1,
  cutoff_central = 5,
  bhd_central = 1000,
  rr_central = 1.1,
  rr_increment = 10,
  erf_shape = "log_linear",
  duration_central = 100,
  dw_central = 1,
  info = "pm2.5_yld"
)

results$health_main$impact


}
\references{
\insertAllCited{}
}
\seealso{
\itemize{
  \item Upstream: \code{\link{prepare_exposure}} (only if no exposure data available)
  \item Alternative: \code{\link{attribute_lifetable}},
    \code{\link{get_paf}}, \code{\link{get_risk}}
  \item Downstream: \code{\link{attribute_mod}}, \code{\link{compare}},
    \code{\link{daly}}, \code{\link{multiexpose}},
    \code{\link{standardize}}, \code{\link{monetize}}, \code{\link{socialize}}
}
}
\author{
Alberto Castro & Axel Luyten
}
