% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print_table_md}
\alias{print_table_md}
\title{Print a character matrix as a table.}
\usage{
print_table_md(
  x,
  col_sep = "",
  header_sep = "",
  row_begin = "",
  row_end = "",
  table_before = NA_character_,
  table_after = NA_character_,
  table_style = c("plain", "md", "latex", "booktabs"),
  ...
)
}
\arguments{
\item{x}{A character matrix.}

\item{col_sep}{Column separator. Default to \code{""}.}

\item{header_sep}{Header separator. Default to \code{"-"}.
If \code{header_sep} only contains one character,
it will be repeated for each column.
If it contains more than one character,
it will be printed below the first row.}

\item{row_begin}{Character at the beginning of each row.
Default to \code{col_sep}.}

\item{row_end}{Character at the ending of each row.
Default to \code{col_sep}.}

\item{table_before}{Characters to be printed before the table.}

\item{table_after}{Characters to be printed after the table.}

\item{table_style}{Name of pre-defined style.
Possible values are \code{"plain"}, \code{"md"}, \code{"latex"}, or \code{"booktabs"}.
Default to \code{"plain"}.}

\item{\dots}{Additional style control arguments.}
}
\value{
No return.
}
\description{
Print a character matrix as a table.
}
\details{
When \code{table_style} is specified, \code{col_sep}, \code{header_sep}, \code{row_begin}
and \code{row_end} would not take effects.
Because this function will automatically set their values.
For each possible value of \code{table_style}, its corresponding style settings
are shown in the following table.
\tabular{llll}{
\tab \strong{\code{plain}} \tab \strong{\code{md}} \tab \strong{\code{latex}} \cr
\code{col_sep}    \tab \code{""}             \tab \code{"|"}         \tab \code{"&"}            \cr
\code{header_sep} \tab \code{""}             \tab \code{"-"}         \tab \code{""}             \cr
\code{row_begin}  \tab \code{""}             \tab \code{"|"}         \tab \code{""}             \cr
\code{row_end}    \tab \code{""}             \tab \code{"|"}         \tab \code{"\\\\"}
}

In this function, characters are right padded by spaces.
}
\seealso{
\code{\link[=print.hgwrm]{print.hgwrm()}}, \code{\link[=summary.hgwrm]{summary.hgwrm()}}.
}
