% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixBothStrandSireOrigin.R
\name{.fixBothStrand}
\alias{.fixBothStrand}
\title{Fix conflicting allele assignments on both haplotype strands}
\usage{
.fixBothStrand(groups)
}
\arguments{
\item{groups}{A numeric matrix with an **even number of rows**. Rows are
interpreted in pairs: rows \code{1,2} form the first pair, \code{3,4} the
second, and so on. Columns represent markers/positions. Values are typically
strand/allele codes; `0` is treated as "unknown/empty", and any non-zero
value indicates an assigned state.}
}
\value{
A numeric matrix with the same dimensions as \code{groups}. For each
row-pair and column:
\itemize{
  \item if both entries are non-zero, both are set to `100`;
  \item otherwise, the original values are preserved.
}
}
\description{
Internal helper that scans a haplotype/strand matrix in *pairs of rows*
(two rows per individual/segment) and detects loci where **both rows in a
pair are non-zero**. Such positions are treated as conflicting assignments
and are replaced with the sentinel value `100` on *both* rows of the pair.
}
\details{
This function is a thin R wrapper around the native routine
\code{fixBothStrand} implemented in C++ and called via \code{.Call()}.


The sentinel value `100` is used downstream as an indicator of an
unresolvable conflict between the two strands at that position.
}
\seealso{
\code{\link{aio}}, \code{\link{ssp}}, \code{\link{bmh}} for the main
hsphase workflow where strand/haplotype matrices are produced and refined.
}
\keyword{internal}
