% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixRotation.R
\name{.fixRotation}
\alias{.fixRotation}
\title{Fix strand label rotation across consecutive block-structure columns}
\usage{
.fixRotation(blockStructure)
}
\arguments{
\item{blockStructure}{A numeric matrix (typically individuals in rows, SNPs
in columns) representing a block/strand structure. Values are expected to be
small integers (commonly including `0`, `1`, `2` and possibly other internal
codes).}
}
\value{
A numeric matrix with the same dimensions as \code{blockStructure},
where some entries in column \code{i+1} may be relabeled to improve
consistency with column \code{i}. The transformation is applied iteratively
from left to right across columns.
}
\description{
Internal helper to enforce a consistent strand-label orientation across
adjacent columns of a block-structure matrix.
}
\details{
The input typically encodes sire strand-of-origin labels per individual
(rows) and marker/SNP (columns), where `0` indicates unknown and non-zero
values indicate an assigned strand/state. The native algorithm compares each
column to the previous one and, when a "contrast" (swap of strand labels)
increases agreement, it relabels the next column to reduce apparent
strand-rotation between columns.

This function is a thin R wrapper around the native routine
\code{fixRotation} implemented in C++ and called via \code{.Call()}.


At each step, the C++ code computes an agreement score between column
\code{i} and column \code{i+1} using only positions where both columns are
non-zero. It also computes the score after applying a contrast mapping to
column \code{i+1} (conceptually swapping strand labels `1` and `2`, leaving
`0` unchanged). If the contrasted version agrees more with column \code{i},
the function relabels column \code{i+1}.

The relabeling performed by the native code is:
\itemize{
  \item `1 -> 3`
  \item `2 -> 1`
  \item `3 -> 2`
}
leaving other values unchanged. (These codes are part of hsphase's internal
block/strand encoding.)
}
\seealso{
\code{\link{bmh}}, \code{\link{ssp}}, \code{\link{aio}} for creation
and downstream usage of block structures.
}

