% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_helper_functions.R
\name{process_ifcb_string}
\alias{process_ifcb_string}
\title{Process IFCB String}
\usage{
process_ifcb_string(ifcb_string, quiet = FALSE)
}
\arguments{
\item{ifcb_string}{A character vector of IFCB filenames to process.}

\item{quiet}{A logical indicating whether to suppress messages for unknown formats. Defaults to \code{FALSE}.}
}
\value{
A character vector containing extracted dates in \code{YYYYMMDD} format, or \code{NA} for unknown formats.
}
\description{
This helper function processes IFCB (Imaging FlowCytobot) filenames and extracts the date component in \code{YYYYMMDD} format.
It supports two formats:
\itemize{
\item \code{IFCB1_2014_188_222013}: Extracts the date using year and day-of-year information.
\item \code{D20240101T120000_IFCB1}: Extracts the date directly from the timestamp.
}
}
\examples{
# Example 1: Process a string in the 'IFCB1_2014_188_222013' format
process_ifcb_string("IFCB1_2014_188_222013")

# Example 2: Process a string in the 'D20240101T120000_IFCB1' format
process_ifcb_string("D20240101T120000_IFCB1")

# Example 3: Process an unknown format
process_ifcb_string("UnknownFormat_12345")

}
