% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocks_functions.R
\name{orbi_define_block_for_flow_injection}
\alias{orbi_define_block_for_flow_injection}
\title{Define data block for flow injection}
\usage{
orbi_define_block_for_flow_injection(
  dataset,
  start_time.min = NULL,
  end_time.min = NULL,
  start_scan.no = NULL,
  end_scan.no = NULL,
  sample_name = NULL
)
}
\arguments{
\item{dataset}{An aggregated dataset or a data frame of peaks (i.e. works directly after \code{\link[=orbi_identify_isotopocules]{orbi_identify_isotopocules()}} as well as with a tibble from \link[=orbi_get_data]{orbi_get_data(peaks = everything())} or when reading from an IsoX file)}

\item{start_time.min}{set the start time of the block}

\item{end_time.min}{set the end time of the block}

\item{start_scan.no}{set the start scan of the block}

\item{end_scan.no}{set the end scan of the block}

\item{sample_name}{if provided, will be used as the \code{sample_name} for the block}
}
\value{
A data frame (tibble) with block definition added. Any data that is not part of a block will be marked with the value of \code{orbi_get_option("data_type_unused")}. Any previously applied segmentation will be discarded (\code{segment} column set to \code{NA}) to avoid unintended side effects.
}
\description{
Define a data block by either start and end time or start and end scan number.
If you want to make segments in the blocks (optional), note that this function - manually defining blocks - removes all block segmentation. Make sure to call \code{\link[=orbi_segment_blocks]{orbi_segment_blocks()}} \strong{only after} finishing block definitions.
}
