% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_print_journal.R
\name{format_journal_df}
\alias{format_journal_df}
\title{Return a table with formatted central, lower, upper}
\usage{
format_journal_df(
  df,
  metric,
  new_var = "clu_fmt",
  style_name = "nature",
  central_var = "mean",
  lower_var = "lower",
  upper_var = "upper",
  remove_clu_columns = TRUE,
  rate_unit = NULL,
  mag = NULL
)
}
\arguments{
\item{df}{[data.frame, data.table]}

\item{metric}{[chr c('prop', 'pp', 'count', 'rate')] a single metric}

\item{new_var}{[chr: default 'clu_fmt'] name of new formatted column}

\item{style_name}{[chr: default 'nature'] style name - controls rounding and
formatting.}

\item{central_var}{[chr: default 'mean'] name of central tendency variable}

\item{lower_var}{[chr: default 'lower'] name of lower bound variable}

\item{upper_var}{[chr: default 'upper'] name of upper bound variable}

\item{remove_clu_columns}{[lgl: default TRUE] remove central, lower, upper
variables after formatting?}

\item{rate_unit}{[chr: default NULL] rate unit label (required when metric = 'rate')
- Examples: "deaths", "cases", "events", "births"}

\item{mag}{[chr: default NULL] magnitude override - see set_magnitude()
- For props/pp: "as-is" (no scaling, use values as provided)
- For counts: "t" (thousand), "m" (million), "b" (billion)
- For rates: "per10", "per100", "per1k", ..., "per10b"
- Examples: "deaths", "cases", "events", "births"}
}
\value{
[data.frame] data.frame, data.table with new 'clu_fmt' column
}
\description{
Assumes a single data-type (metric) for the whole table (e.g. 'prop', 'pp',
'count')
}
\examples{
df <- data.frame(
 location_id = c(1, 2, 3)
 , mean      = c(0.1234, 0, -0.3456)
 , lower     = c(0.1134, -0.2245, -0.4445)
 , upper     = c(0.1334, 0.2445, 0.3556)
)
format_journal_df(df, metric = "prop")

# Rate formatting example
rate_df <- data.frame(
  location = c("Global", "USA"),
  mean     = c(0.0000123, 0.0000456),
  lower    = c(0.0000098, 0.0000401),
  upper    = c(0.0000152, 0.0000512)
)
format_journal_df(rate_df, metric = "rate", rate_unit = "deaths")
}
\seealso{
Other styled_formats: 
\code{\link{format_journal_clu}()},
\code{\link{format_lancet_clu}()},
\code{\link{format_lancet_df}()},
\code{\link{format_metric_cols}()},
\code{\link{format_nature_clu}()},
\code{\link{format_nature_df}()},
\code{\link{fround_clu_triplet}()},
\code{\link{new_style}()}
}
\concept{styled_formats}
