% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esprima.R
\name{esprima}
\alias{esprima}
\alias{esprima_parse}
\alias{esprima_tokenize}
\title{Parse or Tokenize JavaScript code using Esprima}
\usage{
esprima_parse(input, options = NULL, type = "script")

esprima_tokenize(input, options = list())
}
\arguments{
\item{input}{Either a path to a file or a character string containing the JavaScript code to be parsed or tokenized.}

\item{options}{A list of configuration options to pass to the Esprima parser or tokenizer.}

\item{type}{A character string specifying the type of code to parse: "script" (default) or "module".}
}
\value{
For \code{esprima_parse}, a list representing the Abstract Syntax Tree (AST) of the parsed code.
For \code{esprima_tokenize}, a list of tokens extracted from the input code.
}
\description{
Use the Esprima library to parse or tokenize JavaScript code. Note that the
first time this function is called, it will load the esprima library into the JavaScript context,
which may take a few seconds. Subsequent calls will be faster.
}
\examples{
js_code <- 'const answer = 42;'
esprima_parse(js_code)
esprima_tokenize(js_code)
}
