dat <- data.frame(
  Patient_ID = c(
    6L,
    8L,
    14L,
    16L,
    22L,
    24L,
    30L,
    32L,
    38L,
    40L,
    46L,
    48L,
    3L,
    4L,
    11L,
    12L,
    19L,
    20L,
    27L,
    28L,
    35L,
    36L,
    43L,
    44L,
    50L,
    5L,
    7L,
    13L,
    15L,
    21L,
    23L,
    29L,
    31L,
    37L,
    39L,
    45L,
    47L,
    1L,
    2L,
    9L,
    10L,
    17L,
    18L,
    25L,
    26L,
    33L,
    34L,
    41L,
    42L,
    49L
  ),
  Response = c(
    FALSE,
    TRUE,
    TRUE,
    FALSE,
    FALSE,
    TRUE,
    FALSE,
    TRUE,
    FALSE,
    TRUE,
    TRUE,
    FALSE,
    TRUE,
    FALSE,
    FALSE,
    TRUE,
    FALSE,
    TRUE,
    FALSE,
    TRUE,
    FALSE,
    TRUE,
    FALSE,
    TRUE,
    FALSE,
    FALSE,
    TRUE,
    FALSE,
    FALSE,
    FALSE,
    TRUE,
    FALSE,
    TRUE,
    TRUE,
    FALSE,
    FALSE,
    FALSE,
    FALSE,
    TRUE,
    FALSE,
    TRUE,
    TRUE,
    FALSE,
    TRUE,
    FALSE,
    FALSE,
    TRUE,
    FALSE,
    TRUE,
    TRUE
  ),
  Treatment = as.factor(c(
    "A",
    "A",
    "B",
    "B",
    "A",
    "A",
    "B",
    "B",
    "A",
    "A",
    "B",
    "B",
    "A",
    "A",
    "B",
    "B",
    "A",
    "A",
    "B",
    "B",
    "A",
    "A",
    "B",
    "B",
    "A",
    "A",
    "A",
    "B",
    "B",
    "A",
    "A",
    "B",
    "B",
    "A",
    "A",
    "B",
    "B",
    "A",
    "A",
    "B",
    "B",
    "A",
    "A",
    "B",
    "B",
    "A",
    "A",
    "B",
    "B",
    "A"
  )),
  Gender = as.factor(c(
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Female",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male",
    "Male"
  )),
  Age_Group = as.factor(c(
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Old",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young",
    "Young"
  ))
)

lyt <- basic_table(round_type = "sas") |>
  split_cols_by("Treatment", ref_group = "B") |>
  analyze(
    vars = "Response",
    afun = s_proportion_logical,
    table_names = "prop"
  ) |>
  analyze(
    vars = "Response",
    afun = a_relative_risk,
    table_names = "relrisk",
    show_labels = "hidden",
    na_str = default_na_str(),
    extra_args = list(
      variables = list(strata = c("Gender", "Age_Group"), arm = "Treatment"),
      .stats = c("or_ci", "pval")
    )
  ) |>
  analyze(
    vars = "Response",
    afun = a_odds_ratio_j,
    table_names = "oddsratio",
    show_labels = "hidden",
    na_str = default_na_str(),
    extra_args = list(
      variables = list(strata = c("Gender", "Age_Group"), arm = "Treatment"),
      method = "cmh",
      .stats = c("or_ci", "pval")
    )
  )

build_table(lyt, dat)
