% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/windrose.R
\name{windrose}
\alias{windrose}
\title{windrose}
\usage{
windrose(
  data,
  spd,
  dir,
  spdres = 30,
  dirres = 30,
  spdmin = 0,
  spdmax = 150,
  spdseq = NULL,
  palette = "Spectral",
  countmax = NA,
  debug = 0
)
}
\arguments{
\item{data}{ddata frame with two columns including the bearing and distance
or speed of shifts}

\item{spd}{distance or speed column}

\item{dir}{bearing column}

\item{spdres}{30 by default. Numeric; resolution for plotting distance of
speed categories; adapt here the legend and breaks.}

\item{dirres}{30 by default. Numeric, resolution for plotting bearings on
windrose; adapt here the number of bars plotted on the windrose.}

\item{spdmin}{0 by default. Numeric, minimal distance/speed for plotting.}

\item{spdmax}{150 by default. Numeric, maximal distance/speed for plotting.}

\item{spdseq}{NULL}

\item{palette}{Character string defining the color palette to be used.
Available options are taken from rownames(RColorBrewer::brewer.pal.info).}

\item{countmax}{NA by default. Numeric, optional, adjust the y-axis limit
(maximum)}

\item{debug}{0 by default. Numeric, if >0, run debug to find optimal bins of
spd and dir.}
}
\value{
Windrose plot, ggplot object.
}
\description{
Plot the directional shifts for a given bootstrap.
}
\details{
This is intended to plot raw simulation output (that is, bearing
and distance of random shifts) on a windrose.
}
\examples{

\donttest{
study_area <- rnaturalearth::ne_countries(scale = 110, continent = "Europe",
country = "Sweden", type = "map_units", returnclass = "sf")
study_area <- sf::st_union(study_area)
po <- LBI(study_area_id = "Sweden", study_area_polygon = study_area,
nobs = 10, nboot = 10, fact_location = 5, elevation = NULL,
raw_output = TRUE)
test <- as.data.frame(po$all[, c("study_area_id", "distance_km",
"bearing", "rep")])
test$distance_km <- as.numeric(test$distance_km)
pop <- windrose(data = test, spd = "distance_km", dir = "bearing")
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Sanczuk et al. submitted.
}\if{html}{\out{</div>}}
}
