% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ollama.R
\name{list_ollama_models}
\alias{list_ollama_models}
\title{List GGUF models managed by Ollama}
\usage{
list_ollama_models(min_size_mb = 50, verify = TRUE)
}
\arguments{
\item{min_size_mb}{Minimum size (in megabytes) for a candidate GGUF file.
Defaults to 50 MB to avoid tiny placeholder layers.}

\item{verify}{Whether to confirm the GGUF magic header before listing the
model (default `TRUE`).}
}
\value{
A data.frame with columns: `name`, `path`, `size_mb`, `size_gb`,
  `size_bytes`, `sha256`, `modified`, `source`, `tag`, `model`. Returns an
  empty data.frame if no models are found.
}
\description{
This helper scans common Ollama installation directories for downloaded
GGUF weights that can be loaded directly by the `llama.cpp` backend.
It inspects both manifest metadata (when available) and the blobs directory
to return human-readable model descriptions.
}
