% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_experiment.R
\name{read_experiment}
\alias{read_experiment}
\title{Read NetLogo BehaviorSpace Experiment output}
\usage{
read_experiment(file, tidy_output = TRUE)
}
\arguments{
\item{file}{A \code{\link[base:character]{character}} string specifying the path to
the
\href{https://docs.netlogo.org/behaviorspace.html}{BehaviorSpace}
output
\href{https://en.wikipedia.org/wiki/Comma-separated_values}{CSV}
file.}

\item{tidy_output}{(optional) A \code{\link[base:logical]{logical}} flag indicating
whether to tidy the output data frames. If \code{TRUE},
output data frames are arranged according to
\href{https://r4ds.hadley.nz/data-tidy.html}{tidy data principles}.
If \code{FALSE}, only the default transformations from
\code{\link[readr:read_delim]{read_delim()}} and
\code{\link[janitor:clean_names]{clean_names()}} are applied to the output data
(default: \code{TRUE}).}
}
\value{
A \code{\link[base:list]{list}} containing the experiment results. The list
includes the following elements, depending on the output file provided:
\itemize{
\item \code{metadata}: A \code{\link[base:list]{list}} with metadata about the experiment
run (present in all cases).
\item \code{table}: A \code{\link[tibble:tibble]{tibble}} with the results of the
\href{https://docs.netlogo.org/behaviorspace.html#table-output}{\code{table}}
output.
\item \code{spreadsheet}: A \code{\link[base:list]{list}} with the results of the
\href{https://docs.netlogo.org/behaviorspace.html#spreadsheet-output}{\code{spreadsheet}}
output containing two elements:
\itemize{
\item \code{statistics}: A \code{\link[tibble:tibble]{tibble}} with data from the
output first section.
\item \code{data}: A \code{\link[tibble:tibble]{tibble}} with data from the
output second section.
}
\item \code{lists}: A \code{\link[tibble:tibble]{tibble}} with the results of the
\href{https://docs.netlogo.org/behaviorspace.html#lists-output}{\code{lists}}
output.
\item \code{statistics}: A \code{\link[tibble:tibble]{tibble}} with the results of the
\href{https://docs.netlogo.org/behaviorspace.html#statistics-output}{\code{statistics}}
output.
}
}
\description{
\code{read_experiment()} reads NetLogo
\href{https://docs.netlogo.org/behaviorspace.html}{BehaviorSpace}
experiment output files as
\href{https://r4ds.hadley.nz/data-tidy.html}{tidy data frames}.
It automatically detects the output format
(\href{https://docs.netlogo.org/behaviorspace.html#table-output}{Table},
\href{https://docs.netlogo.org/behaviorspace.html#spreadsheet-output}{Spreadsheet},
\href{https://docs.netlogo.org/behaviorspace.html#lists-output}{Lists}, or
\href{https://docs.netlogo.org/behaviorspace.html#statistics-output}{Stats})
and parses the data accordingly. The function also extracts metadata from
the files.

Only version 2.0 (NetLogo 6.4 and later) of BehaviorSpace output files is
supported.
}
\examples{
file <- tempfile()

c(
  'BehaviorSpace results (NetLogo 7.0.3), "Table version 2.0"',
  paste0(
    '"/opt/NetLogo 7-0-3/models/',
    'IABM Textbook/chapter 4/Wolf Sheep Simple 5.nlogox"'
  ),
  '"Wolf Sheep Simple Model Analysis"',
  '"01/05/2026 06:37:48:683 -0300"',
  '"min-pxcor","max-pxcor","min-pycor","max-pycor"',
  '"-17","17","-17","17"',
  paste0(
    '"[run number]","number-of-sheep","number-of-wolves",',
    '"movement-cost","grass-regrowth-rate","energy-gain-from-grass",',
    '"energy-gain-from-sheep","[step]","count wolves","count sheep"'
  ),
  '"3","500","5","0.5","0.3","2","5","0","5","500"',
  '"5","500","5","0.5","0.3","2","5","0","5","500"',
  '"4","500","5","0.5","0.3","2","5","0","5","500"',
  '"6","500","5","0.5","0.3","2","5","0","5","500"',
  '"1","500","5","0.5","0.3","2","5","0","5","500"',
  '"8","500","5","0.5","0.3","2","5","0","5","500"',
  '"9","500","5","0.5","0.3","2","5","0","5","500"',
  '"2","500","5","0.5","0.3","2","5","0","5","500"'
) |>
  writeLines(file)

read_experiment(file)
}
\seealso{
Other BehaviorSpace functions: 
\code{\link{create_experiment}()},
\code{\link{inspect_experiment}()},
\code{\link{run_experiment}()}
}
\concept{BehaviorSpace functions}
