% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizeGGIRDate.R
\name{NormalizeGGIRDate}
\alias{NormalizeGGIRDate}
\title{Normalize GGIR dates to ISO format}
\usage{
NormalizeGGIRDate(x)
}
\arguments{
\item{x}{A vector of dates. Can be of class \code{character}, \code{factor},
\code{numeric}, \code{Date}, or \code{POSIXct}. Mixed formats are allowed.}
}
\value{
A character vector of dates formatted as \code{"YYYY-MM-DD"}.
}
\description{
Convert dates from heterogeneous GGIR output formats into a standard
ISO 8601 date format (\code{"YYYY-MM-DD"}). This function performs
format harmonization only and does not apply any time zone conversion.
}
\details{
GGIR summary files often contain dates stored as formatted strings,
Excel serial numbers, R Date numbers, or POSIX timestamps.
This function detects the input type and converts all values into
a consistent ISO date representation (\code{"YYYY-MM-DD"}), suitable
for merging and aligning GGIR outputs.

Numeric values between 20000 and 60000 are treated as Excel date serials
(origin \code{"1899-12-30"}). Other numeric values are treated as R Date
values (origin \code{"1970-01-01"}).
}
\examples{
NormalizeGGIRDate("2019/01/03")
NormalizeGGIRDate("03-01-2019")
NormalizeGGIRDate(43466)        # Excel date
NormalizeGGIRDate(Sys.time())   # POSIXct


}
