% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr_support.R
\name{maidr_on}
\alias{maidr_on}
\title{Enable MAIDR Rendering in RMarkdown}
\usage{
maidr_on()
}
\value{
Invisible TRUE on success
}
\description{
Enables automatic accessible rendering of ggplot2 and Base R plots
in RMarkdown documents. When enabled, plots are automatically converted
to interactive MAIDR widgets with keyboard navigation and screen reader support.
}
\examples{
\donttest{
# In RMarkdown setup chunk:
library(maidr)
maidr_on()

# Now all plots render as accessible MAIDR widgets
library(ggplot2)
ggplot(mtcars, aes(x = factor(cyl))) +
  geom_bar()

barplot(table(mtcars$cyl))
}
}
\seealso{
[maidr_off()] to disable MAIDR rendering
}
