% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration_functions.R
\name{integrate_complete}
\alias{integrate_complete}
\title{Complete Integration Pipeline (Updated)}
\usage{
integrate_complete(
  agri_data,
  wwtp_nitrogen_aggregated,
  wwtp_phosphorus_aggregated,
  cropland_threshold,
  scale = "huc8",
  add_texas = FALSE,
  year = 2016
)
}
\arguments{
\item{agri_data}{Data frame or sf object. Agricultural classification data}

\item{wwtp_nitrogen_aggregated}{Data frame. Aggregated nitrogen WWTP data}

\item{wwtp_phosphorus_aggregated}{Data frame. Aggregated phosphorus WWTP data}

\item{cropland_threshold}{Numeric. Threshold for exclusion}

\item{scale}{Character. Spatial scale}

\item{add_texas}{Logical. Whether to add Texas HUC8 data (only for HUC8 scale)}

\item{year}{Numeric. Year for Texas data}
}
\value{
List with integrated nitrogen and phosphorus data
}
\description{
Run complete integration of WWTP and agricultural data for both nutrients
}
