% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esp-get-simpl.R
\encoding{UTF-8}
\name{esp_get_simpl}
\alias{esp_get_simpl}
\alias{esp_get_simpl_prov}
\alias{esp_get_simpl_ccaa}
\title{Simplified map of provinces and autonomous communities of Spain}
\source{
INE: PC_Axis files
}
\usage{
esp_get_simpl_prov(
  prov = NULL,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)

esp_get_simpl_ccaa(
  ccaa = NULL,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE
)
}
\arguments{
\item{prov, ccaa}{character. A vector of names and/or codes for provinces
and autonomous communities or \code{NULL} to get all the data. See \strong{Details}.}

\item{update_cache}{logical. Should the cached file be refreshed? Default
is \code{FALSE}. When set to \code{TRUE}, it will force a new download.}

\item{cache_dir}{character string. A path to a cache directory. See
\strong{Caching strategies} section in \code{\link[=esp_set_cache_dir]{esp_set_cache_dir()}}.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
A \code{\link[sf:sf]{sf}} object.
}
\description{
Simplified map with the boundaries of the
provinces or autonomous communities of Spain, as provided by the \strong{INE}
(Instituto Nacional de Estadistica).
}
\details{
Results are provided \strong{without CRS}, as provided by source.

You can use and mix names, ISO codes, \code{"codauto"/ "cpro"} codes (see
\link{esp_codelist}) and NUTS codes of different levels.

When using a code corresponding to a higher level (e.g.
\code{esp_get_prov("Andalucia")}) all the corresponding units of that level are
provided (in this case, all the provinces of Andalusia).
}
\examples{
\dontshow{if (esp_check_access()) withAutoprint(\{ # examplesIf}
\donttest{
prov_simp <- esp_get_simpl_prov()

library(ggplot2)

ggplot(prov_simp) +
  geom_sf(aes(fill = ine.ccaa.name)) +
  labs(fill = "CCAA")

# Provs of Single CCAA

and_simple <- esp_get_simpl_prov("Andalucia")

ggplot(and_simple) +
  geom_sf()

# CCAAs

ccaa_simp <- esp_get_simpl_ccaa()

ggplot(ccaa_simp) +
  geom_sf() +
  geom_sf_text(aes(label = ine.ccaa.name), check_overlap = TRUE)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{esp_get_gridmap}}.

Other datasets representing political borders:
\code{\link{esp_get_capimun}()},
\code{\link{esp_get_ccaa}()},
\code{\link{esp_get_ccaa_siane}()},
\code{\link{esp_get_comarca}()},
\code{\link{esp_get_countries_siane}()},
\code{\link{esp_get_gridmap}},
\code{\link{esp_get_munic}()},
\code{\link{esp_get_munic_siane}()},
\code{\link{esp_get_nuts}()},
\code{\link{esp_get_prov}()},
\code{\link{esp_get_prov_siane}()},
\code{\link{esp_get_spain}()},
\code{\link{esp_get_spain_siane}()},
\code{\link{esp_siane_bulk_download}()}
}
\concept{political}
