% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{vic_fish}
\alias{vic_fish}
\title{Fisheye-Distorted Victoria LGAs (\code{sf})}
\format{
An \code{\link[sf:sf]{sf}} object with:
\describe{
\item{LGA_NAME}{Character, name of the LGA (upper case).}
\item{geometry}{\code{MULTIPOLYGON} / \code{POLYGON} geometries in projected CRS (EPSG:3111).}
}
}
\source{
Prepared in \code{data-raw/gen-data.R} using the original \code{vic} polygon layer.
}
\usage{
vic_fish
}
\description{
An example polygon layer of Victoria’s Local Government Areas (LGAs)
after applying a \strong{Focus–Glue–Context (FGC) fisheye transformation}.
This dataset illustrates how local detail can be magnified around a chosen
focus point while maintaining geographic context across the state.
}
\details{
Built from the base layer \code{vic} using:
\enumerate{
\item projection to VicGrid94 (\code{st_transform(vic, 3111)}),
\item defining a focus center near Melbourne (\code{cx = 145.0}, \code{cy = -37.8}),
\item applying \code{\link[=sf_fisheye]{sf_fisheye()}} with
\code{r_in = 0.34}, \code{r_out = 0.5}, and \code{zoom_factor = 1},
\item preserving topology with \code{st_make_valid()} where needed.
}
The result is a smoothly warped map emphasizing the metropolitan focus zone.
}
\examples{
library(sf)
plot(st_geometry(vic_fish), col = "grey90", border = "grey50")
}
\seealso{
\code{\link[=sf_fisheye]{sf_fisheye()}}, \code{\link{conn_fish}}
}
\keyword{datasets}
