% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmcorr.lpp.R
\name{lmcorr.lpp}
\alias{lmcorr.lpp}
\title{Local mark correlation functions for homogeneous point patterns on linear networks.}
\usage{
\method{lmcorr}{lpp}(X,
ftype = c("variogram", "stoyan", "rcorr", "shimatani", "beisbart",
 "isham", "stoyancov", "schlather"),
r = NULL,
method = c("density","loess"),
normalise = TRUE,
f = NULL,
tol = 0.01,
...)
}
\arguments{
\item{X}{An object of class lpp.}

\item{ftype}{Type of the test function \eqn{t_f}. Currently any selection of \code{"variogram", "stoyan", "rcorr", "shimatani", "beisbart", "isham", "stoyancov", "schlather"}.}

\item{r}{Optional. The values of the argument \eqn{r} at which the mark correlation function should be evaluated.}

\item{method}{Type of smoothing, either \code{density} or \code{loess}. See details.}

\item{normalise}{If \code{normalise=FALSE}, only the numerator of the expression for the mark correlation function will be computed.}

\item{f}{Optional. Test function \eqn{t_f} used in the definition of the mark correlation function. If \code{ftype} is given, \eqn{t_f} should be \code{NULL}.}

\item{tol}{Tolerance used in the calculation of the conditional mean of the marks. This is used only if \code{ftype} is \code{schlather}.}

\item{...}{Arguments passed to \code{\link[spatstat.univar]{unnormdensity}} or \code{\link[stats]{loess}}.}
}
\value{
A \code{data.frame} where the first column contains the values of the argument \eqn{r} at which the mark correlation function is evaluated, and the remaining columns contain the estimated values of the mark correlation function for each data point; column names correspond to the IDs of the data points.
If there are multiple numeric marks, the result will instead be a list, with each element corresponding to one of the marks.
}
\description{
Local mark correlation functions for homogeneous point patterns on linear networks.
}
\details{
This function computes local mark correlation functions for a homogeneous point pattern on a linear network. See the details of test functions used in \code{\link[markstat]{mcorr.lpp}}. Technical details are given in Eckardt and Moradi (2025).
}
\examples{
 library(spatstat.geom)
 library(spatstat.linnet)
 X <- rpoislpp(10, simplenet)
 marks(X) <- runif(npoints(X), 1 ,10)
 lmcorr.lpp(X, ftype = "stoyan", method = "density")
}
\references{
Eckardt, M., & Moradi, M. (2025). Local indicators of mark association for marked spatial point processes.
}
\seealso{
\code{\link[markstat]{mcorr.lpp}}.
}
\author{
Mehdi Moradi \email{m2.moradi@yahoo.com} and Matthias Eckardt
}
