% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_tidy_api.R
\name{find_workflows_for_recipe}
\alias{find_workflows_for_recipe}
\title{Find workflows that use a specific recipe}
\usage{
find_workflows_for_recipe(recipe_id)
}
\arguments{
\item{recipe_id}{Character recipe ID to search for.}
}
\value{
List of RecipeWorkflow objects that reference this recipe.
}
\description{
Cross-reference query: find all workflows that reference a given recipe ID.
}
\examples{
set_workflow_backend("local", path = tempfile(fileext = ".json"))
wfs <- find_workflows_for_recipe("recipe_001")
length(wfs)

}
\seealso{
\code{\link{filter_workflows}}

Other tidy-api: 
\code{\link{RecipeCategory}},
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{add_category}()},
\code{\link{certify_recipe}()},
\code{\link{default_categories}()},
\code{\link{filter_recipes}()},
\code{\link{filter_workflows}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_recipes}()},
\code{\link{rank_workflows}()},
\code{\link{recipe_category}()},
\code{\link{recipe_certification}()},
\code{\link{recipe_user}()},
\code{\link{remove_category}()},
\code{\link{search_recipes}()},
\code{\link{search_workflows}()},
\code{\link{set_user_info}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
