% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_tidy_api.R
\name{rank_recipes}
\alias{rank_recipes}
\title{Rank recipes by downloads}
\usage{
rank_recipes(n = NULL)
}
\arguments{
\item{n}{Integer. Maximum number of recipes to return, or NULL for all.}
}
\value{
List of Recipe objects sorted by downloads (descending).
}
\description{
Get the top recipes ranked by download count from the active backend.
}
\examples{
set_backend("local", path = tempfile(fileext = ".json"))
top10 <- rank_recipes(n = 10)

}
\seealso{
\code{\link{search_recipes}}, \code{\link{filter_recipes}}

Other tidy-api: 
\code{\link{RecipeCategory}},
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{add_category}()},
\code{\link{certify_recipe}()},
\code{\link{default_categories}()},
\code{\link{filter_recipes}()},
\code{\link{filter_workflows}()},
\code{\link{find_workflows_for_recipe}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_workflows}()},
\code{\link{recipe_category}()},
\code{\link{recipe_certification}()},
\code{\link{recipe_user}()},
\code{\link{remove_category}()},
\code{\link{search_recipes}()},
\code{\link{search_workflows}()},
\code{\link{set_user_info}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
