% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipe_tidy_api.R
\name{search_recipes}
\alias{search_recipes}
\title{Search recipes}
\usage{
search_recipes(query)
}
\arguments{
\item{query}{Character search string.}
}
\value{
List of matching Recipe objects.
}
\description{
Search for recipes by name or description in the active backend.
}
\examples{
set_backend("local", path = tempfile(fileext = ".json"))
r <- recipe(
  name = "Labor Market", user = "Test",
  svy = survey_empty(type = "ech", edition = "2023"),
  description = "Labor market indicators"
)
publish_recipe(r)
results <- search_recipes("labor")
length(results)

}
\seealso{
\code{\link{filter_recipes}}, \code{\link{rank_recipes}},
\code{\link{set_backend}}

Other tidy-api: 
\code{\link{RecipeCategory}},
\code{\link{RecipeCertification}},
\code{\link{RecipeUser}},
\code{\link{add_category}()},
\code{\link{certify_recipe}()},
\code{\link{default_categories}()},
\code{\link{filter_recipes}()},
\code{\link{filter_workflows}()},
\code{\link{find_workflows_for_recipe}()},
\code{\link{list_recipes}()},
\code{\link{list_workflows}()},
\code{\link{rank_recipes}()},
\code{\link{rank_workflows}()},
\code{\link{recipe_category}()},
\code{\link{recipe_certification}()},
\code{\link{recipe_user}()},
\code{\link{remove_category}()},
\code{\link{search_workflows}()},
\code{\link{set_user_info}()},
\code{\link{set_version}()}
}
\concept{tidy-api}
