% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steps.R
\name{step_recode}
\alias{step_recode}
\title{Create recoding steps for categorical variables}
\usage{
step_recode(
  svy,
  new_var,
  ...,
  .default = NA_character_,
  .name_step = NULL,
  ordered = FALSE,
  .copy = use_copy_default(),
  comment = "Recode step",
  .to_factor = FALSE,
  .level = "auto",
  use_copy = deprecated()
)
}
\arguments{
\item{svy}{A \code{Survey} or \code{RotativePanelSurvey}
object. If NULL, creates a step that can be
applied later using the pipe operator (\%>\%)}

\item{new_var}{Name of the new variable to create
(unquoted)}

\item{...}{Sequence of two-sided formulas defining
recoding rules. Left-hand side (LHS) is a
conditional expression, right-hand side (RHS)
defines the replacement value.
Format: \code{condition ~ value}}

\item{.default}{Default value assigned when no
condition is met. Defaults to \code{NA_character_}}

\item{.name_step}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Custom name for the step in the history. Now
auto-generated from the variable name. Use \code{comment}
for user-facing documentation instead.}

\item{ordered}{Logical indicating whether the new
variable should be an ordered factor.
Defaults to FALSE}

\item{.copy}{Logical indicating whether to
create a copy of the object before applying
transformations. Defaults to \code{use_copy_default()}}

\item{comment}{Descriptive text for the step for
documentation and traceability. Compatible with
Markdown syntax. Defaults to "Recode step"}

\item{.to_factor}{Logical indicating whether the
new variable should be converted to a factor.
Defaults to FALSE}

\item{.level}{For RotativePanelSurvey objects (default \code{"auto"}),
specifies the level where recoding is applied:
\code{"implantation"}, \code{"follow_up"}, \code{"quarter"},
\code{"month"}, or \code{"auto"}}

\item{use_copy}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{.copy} instead.}
}
\value{
Same type of input object (\code{Survey} or \code{RotativePanelSurvey})
with the new recoded variable and the step added to the history
}
\description{
This function uses optimized expression evaluation
for all recoding conditions. All conditional
expressions are validated and optimized for
efficient execution.
}
\details{
\strong{Lazy evaluation (default):} By default, steps are recorded but
\strong{not executed} until \code{\link[=bake_steps]{bake_steps()}} is called. This allows building
a full pipeline before materializing any changes.

\strong{Condition evaluation:} Conditions are two-sided formulas evaluated
in order. The first matching condition determines the assigned value.
If no condition matches, \code{.default} is used.

Condition examples:
\itemize{
\item Simple: \code{variable == 1 ~ "Yes"}
\item Complex: \code{age >= 18 & income > 12000 ~ "High"}
\item Vectorized: \code{variable \%in\% c(1,2,3) ~ "Group A"}
\item Logical: \code{!is.na(education) ~ "Has education"}
}
}
\examples{
# Basic recode: categorize ages
dt <- data.table::data.table(
  id = 1:6, age = c(10, 25, 45, 60, 70, 80), w = 1
)
svy <- Survey$new(
  data = dt, edition = "2023", type = "test",
  psu = NULL, engine = "data.table",
  weight = add_weight(annual = "w")
)
svy <- svy |>
  step_recode(
    age_group,
    age < 18 ~ "Under 18",
    age >= 18 & age < 65 ~ "Working age",
    age >= 65 ~ "Senior",
    .default = "Unknown"
  )
svy <- bake_steps(svy)
get_data(svy)

\donttest{
# ECH example: labor force status
# ech <- ech |>
#   step_recode(labor_status,
#     POBPCOAC == 2 ~ "Employed",
#     POBPCOAC \%in\% 3:5 ~ "Unemployed",
#     .default = "Missing")
}

}
\seealso{
\code{\link{step_compute}} for more complex calculations
\code{\link{bake_steps}} to execute all pending steps
\code{\link{get_steps}} to view step history

Other steps: 
\code{\link{bake_steps}()},
\code{\link{get_steps}()},
\code{\link{step_compute}()},
\code{\link{step_filter}()},
\code{\link{step_join}()},
\code{\link{step_remove}()},
\code{\link{step_rename}()},
\code{\link{step_validate}()},
\code{\link{view_graph}()}
}
\concept{steps}
\keyword{step}
