% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mica.R
\name{mica.login}
\alias{mica.login}
\title{Open connection with Mica}
\usage{
mica.login(
  username = getOption("mica.username", "anonymous"),
  password = getOption("mica.password", "password"),
  url = getOption("mica.url"),
  opts = getOption("mica.opts", list())
)
}
\arguments{
\item{username}{User name in mica. Can be provided by "mica.username" option.}

\item{password}{User password in mica. Can be provided by "mica.password" option.}

\item{url}{Mica url or list of mica urls. Can be provided by "mica.url" option. Secure http (https) connection is required.}

\item{opts}{Curl options. Can be provided by "mica.opts" option.}
}
\value{
A Mica object.
}
\description{
Open a connection with Mica and returns a Mica object. When the two-factor
authentication mechanism is enabled, the user will be prompt for one-time password input.
}
\examples{
\dontrun{
# login using credentials from mica.username and mica.password options
m <- mica.login("https://mica-demo.obiba.org")
# login by providing credentials
m <- mica.login("administrator", "password", "https://mica-demo.obiba.org")
}
}
