% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchers.R
\name{ssh_config}
\alias{ssh_config}
\title{SSH Remote Launch Configuration}
\usage{
ssh_config(
  remotes,
  tunnel = FALSE,
  timeout = 10,
  command = "ssh",
  rscript = "Rscript"
)
}
\arguments{
\item{remotes}{(character) URL(s) to SSH into using scheme 'ssh://', e.g.
'ssh://10.75.32.90:22' or 'ssh://nodename'. Port defaults to 22.}

\item{tunnel}{(logical) whether to use SSH tunnelling. Requires \code{url}
hostname '127.0.0.1' (use \code{\link[=local_url]{local_url()}} with \code{tcp = TRUE}). See SSH
Tunnelling section.}

\item{timeout}{(integer) maximum seconds for connection setup.}

\item{command}{(character) shell command for launching daemons (e.g.
\code{"ssh"}). \code{NULL} returns shell commands for manual deployment without
launching.}

\item{rscript}{(character) Rscript executable. Use full path if needed, or
\code{"Rscript.exe"} on Windows.}
}
\value{
A list in the required format to be supplied to the \code{remote} argument
of \code{\link[=daemons]{daemons()}} or \code{\link[=launch_remote]{launch_remote()}}.
}
\description{
Generates a remote configuration for launching daemons over SSH, with the
option of SSH tunnelling.
}
\section{SSH Direct Connections}{


The simplest use of SSH is to execute the daemon launch command on a remote
machine, for it to dial back to the host / dispatcher URL.

SSH key-based authentication must already be in place. The relevant port on
the host must be open to inbound connections from the remote machine. This
approach is suited to trusted networks.
}

\section{SSH Tunnelling}{


SSH tunnelling launches remote daemons without requiring the remote machine
to access the host directly. Often firewall configurations or security
policies may prevent opening a port to accept outside connections.

A tunnel is created once the initial SSH connection is made. For simplicity,
this SSH tunnelling implementation uses the same port on both host and
daemon. SSH key-based authentication must already be in place, but no other
configuration is required.

To use tunnelling, set the hostname of the \code{\link[=daemons]{daemons()}} \code{url} argument to be
'127.0.0.1'. Using \code{\link[=local_url]{local_url()}} with \code{tcp = TRUE} also does this for you.
Specifying a specific port to use is optional, with a random ephemeral port
assigned otherwise. For example, specifying 'tcp://127.0.0.1:5555' uses the
local port '5555' to create the tunnel on each machine. The host listens
to '127.0.0.1:5555' on its machine and the remotes each dial into
'127.0.0.1:5555' on their own respective machines.

Daemons can be launched on any machine accessible via SSH, whether on the
local network or in the cloud.
}

\examples{
# direct SSH example
ssh_config(c("ssh://10.75.32.90:222", "ssh://nodename"), timeout = 5)

# SSH tunnelling example
ssh_config(c("ssh://10.75.32.90:222", "ssh://nodename"), tunnel = TRUE)

\dontrun{

# launch daemons on the remote machines 10.75.32.90 and 10.75.32.91 using
# SSH, connecting back directly to the host URL over a TLS connection:
daemons(
  n = 1,
  url = host_url(tls = TRUE),
  remote = ssh_config(c("ssh://10.75.32.90:222", "ssh://10.75.32.91:222"))
)

# launch 2 daemons on the remote machine 10.75.32.90 using SSH tunnelling:
daemons(
  n = 2,
  url = local_url(tcp = TRUE),
  remote = ssh_config("ssh://10.75.32.90", tunnel = TRUE)
)
}

}
\seealso{
\code{\link[=cluster_config]{cluster_config()}}, \code{\link[=http_config]{http_config()}} and \code{\link[=remote_config]{remote_config()}} for other
types of remote configuration.
}
