% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_task.R
\name{as_task}
\alias{as_task}
\alias{as_task.Task}
\alias{as_tasks}
\alias{as_tasks.default}
\alias{as_tasks.list}
\title{Convert to a Task}
\usage{
as_task(x, ...)

\method{as_task}{Task}(x, clone = FALSE, ...)

as_tasks(x, ...)

\method{as_tasks}{default}(x, ...)

\method{as_tasks}{list}(x, ...)
}
\arguments{
\item{x}{(any)\cr
Object to convert.}

\item{...}{(any)\cr
Additional arguments.}

\item{clone}{(\code{logical(1)})\cr
If \code{TRUE}, ensures that the returned object is not the same as the input \code{x}.}
}
\description{
Convert object to a \link{Task} or a list of \link{Task}.

The function supports:
\itemize{
\item Converting existing \link{Task} objects (with optional cloning)
\item Converting objects from other packages (e.g., \code{OMLTask} from \CRANpkg{mlr3oml})
\item Converting lists of objects to lists of tasks
}

For constructing tasks from data frames, use the dedicated converters:
\itemize{
\item \code{\link[=as_task_classif]{as_task_classif()}} for classification tasks
\item \code{\link[=as_task_regr]{as_task_regr()}} for regression tasks
\item \code{\link[=as_task_unsupervised]{as_task_unsupervised()}} for unsupervised tasks
}
}
