% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{orthogonality_violation}
\alias{orthogonality_violation}
\title{Orthogonality constraint violation}
\usage{
orthogonality_violation(U)
}
\arguments{
\item{U}{A matrix. Each column correspond to an p-dimensional PC.}
}
\value{
A float.
}
\description{
Computes the orthogonality constraint violation defined as the distance (infinity norm) between \eqn{U^\top U} and the identity matrix.
}
\examples{
library(datasets)
TestMat <- cor(datasets::mtcars)
mspcares <- mspca(TestMat, 2, c(4,4))
orthogonality_violation(mspcares$x_best)
}
