% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrospective.R
\name{retrospective}
\alias{retrospective}
\alias{plot.MSAretro}
\alias{summary.MSAretro}
\alias{report.MSAretro}
\title{Retrospective analysis}
\usage{
retrospective(MSAassess, yret = 0:5, cores = 1)

\method{plot}{MSAretro}(
  x,
  var = c("S_yst", "R_yst", "F_yst", "log_rdev_yst", "VB_ymft"),
  s = 1,
  f = 1,
  ...
)

\method{summary}{MSAretro}(object, by = c("stock", "fleet"), ...)

\method{report}{MSAretro}(
  object,
  filename = "retro",
  dir = tempdir(),
  open_file = TRUE,
  render_args = list(),
  ...
)
}
\arguments{
\item{MSAassess}{\linkS4class{MSAassess} object}

\item{yret}{Vector specifying the years (positive integers and include zero) to remove for the retrospective analysis}

\item{cores}{Integer for the number of cores to use for parallel processing (snowfall package)}

\item{x, object}{Output of \code{retrospective} function}

\item{var}{Character to indicate the metric, the item in the \code{MSAretro} list to be plotted. See details below.}

\item{s}{Integer for the stock index to plot}

\item{f}{Integer for the fleet index to plot}

\item{...}{Not used}

\item{by}{Character indicating whether to calculate to Mohn's rho on stock or fleet-based time series}

\item{filename}{Character string for the name of the markdown and HTML files.}

\item{dir}{The directory in which the markdown and HTML files will be saved.}

\item{open_file}{Logical, whether the HTML document is opened after it is rendered.}

\item{render_args}{List of arguments to pass to \code{\link[rmarkdown:render]{rmarkdown::render()}}.}
}
\value{
A \code{MSAretro} object containing a named lists of arrays generated by the retrospective analysis:
\itemize{
\item \code{S_yst} Spawning output array \verb{[y, s, t]} where \code{t} indexes the retrospective peel
\item \code{R_yst} Recruitment array \verb{[y, s, t]}
\item \code{F_yst} Apical fishing mortality \verb{[y, s, t]}
\item \code{VB_ymft} Vulnerable biomass available to each fishery \verb{[y, m, f, t]}
}

\code{plot.MSAretro} returns individual figures using base graphics.

\code{summary.MSAretro} returns a matrix of Mohn's rho.

\code{report.MSAretro} invisibly returns the output of \code{\link[rmarkdown:render]{rmarkdown::render()}}: character of the path of the rendered HTML markdown report.
}
\description{
Perform a retrospective analysis, successive removals of most recent years of data to evaluate
consistency in model estimates of biomass, recruitment, etc.

The \code{summary} method returns Mohn's rho and the plot method generates a markdown report.
}
