% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{IS}
\alias{IS}
\title{Calculate F-statistics and Q-statistic for instrument strength (internal)}
\usage{
IS(J, K, PC, datafull, Y = NULL)
}
\arguments{
\item{J}{Number of genetic instruments}

\item{K}{Number of exposures}

\item{PC}{Vector of indices indicating which columns in datafull correspond to the principal components}

\item{datafull}{Data frame containing instruments (first J columns) and principal components (subsequent columns) [G, X]}

\item{Y}{Optional outcome vector; if provided, Q-statistic for overidentification is calculated)}
}
\value{
Matrix with columns: PC (component index), RR (R-squared), FF (F-statistic), cFF (conditional F-statistic). If Y is provided, additional columns: Qvalue (Hansen's J overidentification test statistic), df (degrees of freedom for Q-test), pvalue (p-value for Q-test from chi-squared distribution).
}
\description{
Calculate F-statistics and Q-statistic for instrument strength (internal)
}
