% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{getX_multi_exposure_mediation}
\alias{getX_multi_exposure_mediation}
\title{Generate multi-exposure mediation data with genetic instruments}
\usage{
getX_multi_exposure_mediation(
  N = 10000,
  J = 30,
  ZXmodel = "A",
  nSparse = 10,
  mediation_strength = 0.3,
  separate_G = FALSE,
  shared_G_proportion = 0,
  mediation_type = "linear"
)
}
\arguments{
\item{N}{Sample size}

\item{J}{Number of genetic instruments per exposure}

\item{ZXmodel}{Model type (currently not used, kept for compatibility)}

\item{nSparse}{Number of sparse observations per subject}

\item{mediation_strength}{Strength of mediation X1 -> X2 (default 0.3)}

\item{separate_G}{Whether to use separate instruments for each exposure}

\item{shared_G_proportion}{Proportion of shared instruments (0–1)}

\item{mediation_type}{Character. Type of mediation effect: "linear" (default), "nonlinear", or "time_varying".}
}
\value{
List with same structure as getX_multi_exposure()
}
\description{
Generate multi-exposure mediation data with genetic instruments
}
