% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_epred.mvgam.R
\name{fitted.mvgam}
\alias{fitted.mvgam}
\title{Expected values of the posterior predictive distribution for \pkg{mvgam} objects}
\usage{
\method{fitted}{mvgam}(
  object,
  process_error = TRUE,
  scale = c("response", "linear"),
  summary = TRUE,
  robust = FALSE,
  probs = c(0.025, 0.975),
  ...
)
}
\arguments{
\item{object}{An object of class \code{mvgam}}

\item{process_error}{Logical. If \code{TRUE} and a dynamic trend model was
fit, expected uncertainty in the process model is accounted for by using
draws from a stationary, zero-centred multivariate Normal distribution
using any estimated process variance-covariance parameters. If
\code{FALSE}, uncertainty in the latent trend component is ignored when
calculating predictions}

\item{scale}{Either \code{"response"} or \code{"linear"}.
If \code{"response"}, results are returned on the scale
of the response variable. If \code{"linear"},
results are returned on the scale of the linear predictor term,
that is without applying the inverse link function or
other transformations.}

\item{summary}{Should summary statistics be returned
instead of the raw values? Default is \code{TRUE}..}

\item{robust}{If \code{FALSE} (the default) the mean is used as
the measure of central tendency and the standard deviation as
the measure of variability. If \code{TRUE}, the median and the
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile}
function. Only used if \code{summary} is \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link[brms]{prepare_predictions}}
that control several aspects of data validation and prediction.}
}
\value{
An \code{array} of predicted \emph{mean} response values.

If \code{summary = FALSE} the output resembles those of
\code{\link{posterior_epred.mvgam}} and \code{\link{predict.mvgam}}.

If \code{summary = TRUE} the output is an \code{n_observations} x \code{E}
matrix. The number of summary statistics \code{E} is equal to \code{2 +
  length(probs)}: The \code{Estimate} column contains point estimates (either
mean or median depending on argument \code{robust}), while the
\code{Est.Error} column contains uncertainty estimates (either standard
deviation or median absolute deviation depending on argument
\code{robust}). The remaining columns starting with \code{Q} contain
quantile estimates as specified via argument \code{probs}.
}
\description{
This method extracts posterior estimates of the fitted values (i.e. the
actual predictions, including estimates for any trend states, that were
obtained when fitting the model). It also includes an option for obtaining
summaries of the computed draws.
}
\details{
This method gives the actual fitted values from the model (i.e. what
you will see if you generate hindcasts from the fitted model using
\code{\link{hindcast.mvgam}} with \code{type = 'expected'}). These predictions
can be overly precise if a flexible dynamic trend component was included in
the model. This is in contrast to the set of predict functions (i.e.
\code{\link{posterior_epred.mvgam}} or \code{\link{predict.mvgam}}), which
will assume any dynamic trend component has reached stationarity when
returning hypothetical predictions.
}
\examples{
\dontrun{
# Simulate some data and fit a model
simdat <- sim_mvgam(n_series = 1, trend_model = AR())

mod <- mvgam(
  y ~ s(season, bs = 'cc'),
  trend_model = AR(),
  data = simdat$data_train,
  chains = 2,
  silent = 2
)

# Extract fitted values (posterior expectations)
expectations <- fitted(mod)
str(expectations)
}

}
\seealso{
\code{\link{hindcast.mvgam}}
}
\author{
Nicholas J Clark
}
