% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_super_learner.R
\name{cv_super_learner_internal}
\alias{cv_super_learner_internal}
\title{Apply Cross-Validation to a Super Learner Closure}
\usage{
cv_super_learner_internal(
  data,
  sl_closure,
  y_variable = NULL,
  n_folds = 5,
  cv_schema = cv_random_schema,
  loss_metric,
  outcome_type = "continuous"
)
}
\arguments{
\item{data}{Data to use in training a \code{super_learner}.}

\item{sl_closure}{A function that takes in data and produces a \code{super_learner} predictor.}

\item{y_variable}{The string name of the outcome column in \code{data}}

\item{n_folds}{The number of cross-validation folds to use in constructing the \code{super_learner}.}

\item{cv_schema}{A function that takes \code{data}, \code{n_folds} and returns a list containing \code{training_data} and \code{validation_data}, each of which are lists of \code{n_folds} data frames.}

\item{loss_metric}{A loss metric function, like the mean-squared-error or negative-log-loss to be
used in evaluating the learners on held-out data and minimized through convex optimization.
A loss metric should take two (vector) arguments:
predictions, and true outcomes, and produce a single statistic summarizing the
performance of each learner. Defaults to the mean-squared-error \code{nadir:::mse()}.}

\item{outcome_type}{One of 'continuous', 'binary', 'multiclass', or 'density'. \code{outcome_type} is used to infer the correct \code{determine_super_learner_weights} function if it is not explicitly passed.}
}
\value{
A list containing \code{$trained_learners} and \code{$cv_loss} which
respectively include 1) the trained super learner models on each fold of the data, their holdout predictions and,
2) the cross-validated estimate of the risk (expected loss) on held-out data.
}
\description{
Taking an \code{sl_closure}, a function that trains a super learner on one
argument \code{data} and produces a predictor function, \code{cv_super_learner_internal}
applies cross validation to this \code{sl_closure} with the data passed.
}
\keyword{internal}
