% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mantel-test.R
\name{mantel.test}
\alias{mantel.test}
\title{Mantel Test}
\usage{
mantel.test(
  M1 = NULL,
  M2 = NULL,
  x = NULL,
  y = NULL,
  z = NULL,
  resamp = 999,
  latlon = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{M1}{similarity/distance matrix 1}

\item{M2}{similarity/distance matrix 2}

\item{x}{vector of length n representing the x coordinates (or longitude; see latlon).}

\item{y}{vector of length n representing the y coordinates (or latitude).}

\item{z}{matrix of dimension n x p representing p observation at each location.}

\item{resamp}{the number of resamples for the null distribution.}

\item{latlon}{If TRUE, coordinates are latitude and longitude.}

\item{quiet}{If TRUE, the counter is suppressed during execution.}
}
\value{
An object of class "Mantel" is returned, consisting of a list with two components:
\item{correlation}{the value for the Mantel correlation.}
\item{p}{the randomization-based two-sided p-value.}
}
\description{
A simple function to do a permutation-based Mantel test. The data can either be two distance/similarity matrices or (x, y, z) data.
}
\details{
Typical usages are
\preformatted{
mantel.test(M1, M2, x = NULL, y = NULL, z = NULL, resamp = 999, 
            latlon = FALSE, quiet = FALSE)

mantel.test(x, y, z, M1 = NULL, M2 = NULL, resamp = 999, latlon = FALSE, 
            quiet = FALSE)
}

  Missing values are treated through pairwise deletion.
}
\examples{
# first generate some sample data
x <- expand.grid(1:20, 1:5)[, 1]
y <- expand.grid(1:20, 1:5)[, 2]
# z data from an exponential random field
z <- cbind(
  rmvn.spa(x = x, y = y, p = 2, method = "exp"), 
  rmvn.spa(x = x, y = y, p = 2, method = "exp")
  )

# the Mantel test
mantel.test(x = x, y = y, z = z[, 1], resamp = 999)
}
\author{
Ottar N. Bjornstad \email{onb1@psu.edu}
}
\keyword{spatial}
