% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nulls-moran.R
\name{null_moran}
\alias{null_moran}
\title{Moran spectral randomization null model}
\usage{
null_moran(
  data,
  distmat,
  n_perm = 1000L,
  seed = NULL,
  procedure = c("pair", "singleton"),
  kernel = c("inverse_distance", "exponential", "gaussian", "bisquare"),
  tol = 1e-06
)
}
\arguments{
\item{data}{Numeric vector of brain map values.}

\item{distmat}{Distance matrix between parcels/vertices.}

\item{n_perm}{Integer number of null permutations to generate.}

\item{seed}{Optional integer seed for reproducibility.}

\item{procedure}{Character, either \code{"pair"} (default, random 2D rotations
of near-degenerate eigenvector pairs, matches neuromaps Python) or
\code{"singleton"} (random sign flips of individual eigenvectors).}

\item{kernel}{Weight matrix kernel: \code{"inverse_distance"} (default, matches
neuromaps Python), \code{"exponential"}, \code{"gaussian"}, or \code{"bisquare"}.}

\item{tol}{Numeric tolerance for eigenvalue comparison.}
}
\value{
A \link{null_distribution} object.
}
\description{
Generates spatially-constrained surrogate brain maps using Moran's
eigenvector maps (MEMs) for spectral randomization.
}
\examples{
data <- rnorm(50)
distmat <- as.matrix(dist(matrix(rnorm(100), 50, 2)))
nd <- null_moran(data, distmat, n_perm = 10L, seed = 1L)
}
\references{
Wagner HH, Dray S (2015) Methods in Ecology and Evolution 6:1169-1178.
doi:10.1111/2041-210X.12407
}
