% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runNestedApprox.R
\name{sampleParams}
\alias{sampleParams}
\title{Sample from the parameter posterior distribution}
\usage{
sampleParams(summary, n = 1000, matchMarginals = TRUE)
}
\arguments{
\item{summary}{an approxSummary object, returned by \code{runNestedApprox}.}

\item{n}{number of samples to draw. Default is 1000.}

\item{matchMarginals}{logical; if \code{TRUE} (the default), match marginals using copula approach.}
}
\value{
Matrix of parameter samples.
}
\description{
Draws samples from the parameter posterior using the asymmetric Gaussian approximation. 
Optionally uses a copula approach to match the univariate marginals to the 
currently-available marginal distributions (based on either the initial asymmetric 
Gaussian approximation or improved marginals from 
calling \code{improveParamMarginals}).
}
\details{
Draws samples from the joint parameter posterior distribution (marginalized with respect to the latent nodes)
using the asymmetric Gaussian approximation.

This is useful for joint inference on the parameters, including inference on functions of more than one parameter.

See \code{runNestedApprox} for example usage.
}
