% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/criticaldiff.R
\name{criticaldiff}
\alias{criticaldiff}
\title{Differences between the critical points  
for two factor's levels}
\usage{
criticaldiff(model, level1 = NULL, level2 = NULL, der = NULL)
}
\arguments{
\item{model}{Parametric or nonparametric regression model 
obtained by \code{\link{frfast}} function.}

\item{level1}{First factor's level at which to perform the differences 
between critical points.}

\item{level2}{Second factor's level at which to perform the differences 
between critical points.}

\item{der}{Number which determines any inference process. By default 
\code{der} is \code{NULL}. If this term is \code{0}, the calculate of the 
differences for the critical point is for the estimate. If it is \code{1} or 
\code{2}, it is designed for the first or second derivative, respectively.}
}
\value{
An object is returned with the following elements:
\item{critical.diff}{a table with a couple of factor's level where it is used 
to calculate the differences between the critical points, and their 
95\% confidence interval (for the estimation, first and second derivative).}
}
\description{
Differences between the estimation of \code{\link{critical}} for two 
factor's levels.
}
\details{
Differences are calculated by subtracting a factor relative to 
another (\eqn{level2 - level1}).  By default \code{level2} and 
\code{level1} are \code{NULL}, so the differences calculated are for all 
possible combinations between two factors. Additionally, it is obtained 
the 95\% confidence interval for this difference which let us to make
inference about them.
}
\examples{
library(npregfast)
data(barnacle)
fit2 <- frfast(DW ~ RC : F, data = barnacle, seed = 130853, nboot = 100) # with interactions
criticaldiff(fit2)
criticaldiff(fit2, der = 1)
criticaldiff(fit2, der = 1, level1 = "lens", level2 = "barca")

}
\references{
Sestelo, M. (2013). Development and computational implementation of 
estimation and inference methods in flexible regression models. 
Applications in Biology, Engineering and Environment. PhD Thesis, Department
of Statistics and O.R. University of Vigo.

Sestelo, M., Villanueva, N.M., Meira-Machado, L., Roca-Pardinas, J. (2017). 
npregfast: An R Package for Nonparametric Estimation and Inference in Life 
Sciences. Journal of Statistical Software, 82(12), 1-27.
}
\author{
Marta Sestelo, Nora M. Villanueva and Javier Roca-Pardinas.
}
