% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domains.R
\name{DomainsResource}
\alias{DomainsResource}
\title{Domains Resource}
\value{
Domain list with summary.

Paginated concepts.
}
\description{
R6 class providing access to domain operations.
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DomainsResource-new}{\code{DomainsResource$new()}}
\item \href{#method-DomainsResource-list}{\code{DomainsResource$list()}}
\item \href{#method-DomainsResource-concepts}{\code{DomainsResource$concepts()}}
\item \href{#method-DomainsResource-print}{\code{DomainsResource$print()}}
\item \href{#method-DomainsResource-clone}{\code{DomainsResource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DomainsResource-new"></a>}}
\if{latex}{\out{\hypertarget{method-DomainsResource-new}{}}}
\subsection{Method \code{new()}}{
Create a new DomainsResource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DomainsResource$new(base_req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_req}}{Base httr2 request object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DomainsResource-list"></a>}}
\if{latex}{\out{\hypertarget{method-DomainsResource-list}{}}}
\subsection{Method \code{list()}}{
List all domains.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DomainsResource$list(
  vocabulary_ids = NULL,
  include_concept_counts = TRUE,
  include_statistics = FALSE,
  include_examples = FALSE,
  standard_only = FALSE,
  active_only = TRUE,
  sort_by = "domain_id",
  sort_order = "asc"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vocabulary_ids}}{Filter by vocabularies.}

\item{\code{include_concept_counts}}{Include concept counts. Default \code{TRUE}.}

\item{\code{include_statistics}}{Include detailed statistics. Default \code{FALSE}.}

\item{\code{include_examples}}{Include example concepts. Default \code{FALSE}.}

\item{\code{standard_only}}{Only standard concepts. Default \code{FALSE}.}

\item{\code{active_only}}{Only active domains. Default \code{TRUE}.}

\item{\code{sort_by}}{Sort field. Default "domain_id".}

\item{\code{sort_order}}{Sort order. Default "asc".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DomainsResource-concepts"></a>}}
\if{latex}{\out{\hypertarget{method-DomainsResource-concepts}{}}}
\subsection{Method \code{concepts()}}{
Get concepts in a domain.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DomainsResource$concepts(
  domain_id,
  vocabulary_ids = NULL,
  concept_class_ids = NULL,
  standard_only = FALSE,
  page = 1,
  page_size = 50
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{domain_id}}{The domain ID.}

\item{\code{vocabulary_ids}}{Filter by vocabularies.}

\item{\code{concept_class_ids}}{Filter by concept classes.}

\item{\code{standard_only}}{Only standard concepts. Default \code{FALSE}.}

\item{\code{page}}{Page number. Default 1.}

\item{\code{page_size}}{Results per page. Default 50.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DomainsResource-print"></a>}}
\if{latex}{\out{\hypertarget{method-DomainsResource-print}{}}}
\subsection{Method \code{print()}}{
Print resource information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DomainsResource$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DomainsResource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DomainsResource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DomainsResource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
