% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{HierarchyResource}
\alias{HierarchyResource}
\title{Hierarchy Resource}
\value{
Ancestors with hierarchy summary.

Descendants with hierarchy summary.
}
\description{
R6 class providing access to hierarchy operations (ancestors and descendants).
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HierarchyResource-new}{\code{HierarchyResource$new()}}
\item \href{#method-HierarchyResource-ancestors}{\code{HierarchyResource$ancestors()}}
\item \href{#method-HierarchyResource-descendants}{\code{HierarchyResource$descendants()}}
\item \href{#method-HierarchyResource-print}{\code{HierarchyResource$print()}}
\item \href{#method-HierarchyResource-clone}{\code{HierarchyResource$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HierarchyResource-new"></a>}}
\if{latex}{\out{\hypertarget{method-HierarchyResource-new}{}}}
\subsection{Method \code{new()}}{
Create a new HierarchyResource.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HierarchyResource$new(base_req)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{base_req}}{Base httr2 request object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HierarchyResource-ancestors"></a>}}
\if{latex}{\out{\hypertarget{method-HierarchyResource-ancestors}{}}}
\subsection{Method \code{ancestors()}}{
Get concept ancestors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HierarchyResource$ancestors(
  concept_id,
  vocabulary_id = NULL,
  max_levels = NULL,
  relationship_types = NULL,
  include_paths = FALSE,
  include_distance = TRUE,
  standard_only = FALSE,
  include_deprecated = FALSE,
  page = 1,
  page_size = 100
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_id}}{The concept ID.}

\item{\code{vocabulary_id}}{Filter to specific vocabulary.}

\item{\code{max_levels}}{Maximum hierarchy levels to traverse.}

\item{\code{relationship_types}}{Relationship types to follow (default: "Is a").}

\item{\code{include_paths}}{Include path information. Default \code{FALSE}.}

\item{\code{include_distance}}{Include distance from source. Default \code{TRUE}.}

\item{\code{standard_only}}{Only return standard concepts. Default \code{FALSE}.}

\item{\code{include_deprecated}}{Include deprecated concepts. Default \code{FALSE}.}

\item{\code{page}}{Page number. Default 1.}

\item{\code{page_size}}{Results per page. Default 100.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HierarchyResource-descendants"></a>}}
\if{latex}{\out{\hypertarget{method-HierarchyResource-descendants}{}}}
\subsection{Method \code{descendants()}}{
Get concept descendants.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HierarchyResource$descendants(
  concept_id,
  vocabulary_id = NULL,
  max_levels = 10,
  relationship_types = NULL,
  include_distance = TRUE,
  standard_only = FALSE,
  include_deprecated = FALSE,
  domain_ids = NULL,
  concept_class_ids = NULL,
  include_synonyms = FALSE,
  page = 1,
  page_size = 100
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{concept_id}}{The concept ID.}

\item{\code{vocabulary_id}}{Filter to specific vocabulary.}

\item{\code{max_levels}}{Maximum hierarchy levels (default 10, max 10).}

\item{\code{relationship_types}}{Relationship types to follow.}

\item{\code{include_distance}}{Include distance from source. Default \code{TRUE}.}

\item{\code{standard_only}}{Only return standard concepts. Default \code{FALSE}.}

\item{\code{include_deprecated}}{Include deprecated concepts. Default \code{FALSE}.}

\item{\code{domain_ids}}{Filter by domains.}

\item{\code{concept_class_ids}}{Filter by concept classes.}

\item{\code{include_synonyms}}{Include synonyms. Default \code{FALSE}.}

\item{\code{page}}{Page number. Default 1.}

\item{\code{page_size}}{Results per page. Default 100.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HierarchyResource-print"></a>}}
\if{latex}{\out{\hypertarget{method-HierarchyResource-print}{}}}
\subsection{Method \code{print()}}{
Print resource information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HierarchyResource$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HierarchyResource-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HierarchyResource-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HierarchyResource$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
