% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{get_api_key}
\alias{get_api_key}
\title{Get OMOPHub API Key}
\usage{
get_api_key(key = NULL)
}
\arguments{
\item{key}{Optional explicit API key. If provided, this takes precedence.}
}
\value{
A character string containing the API key.
}
\description{
Retrieves the OMOPHub API key from multiple sources in priority order:
\enumerate{
\item Explicit argument
\item \code{OMOPHUB_API_KEY} environment variable
\item System keyring (if \code{keyring} package is installed)
}
}
\examples{
\dontrun{
# From environment variable
Sys.setenv(OMOPHUB_API_KEY = "your_api_key")
key <- get_api_key()

# Explicit key
key <- get_api_key("your_api_key")
}
}
