% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Goodman_diagonals_parameter_symmetry.R
\name{Goodman_fixed_parameter}
\alias{Goodman_fixed_parameter}
\title{Fits the model with given parameters fixed to specific values.}
\usage{
Goodman_fixed_parameter(
  n,
  delta,
  fixed,
  convergence = 1e-04,
  max_iter = 50,
  verbose = FALSE
)
}
\arguments{
\item{n}{the r X r matrix of observed counts}

\item{delta}{the vector of asymmetry r - 1 parameters}

\item{fixed}{r - 1 logical vector that specifies whether a delta parameter is fixed
(TRUE) or allowed to be estimated (FALSE).}

\item{convergence}{maximum change in a parameter across iterations. Default is 1.0e-4}

\item{max_iter}{maximum number of iterations, Default is 50.}

\item{verbose}{should progress information be printed to the console. Default is
FALSE, do not print.}
}
\value{
list containing phi, delta,
   max_change largest change in  parameter for last the iteration,
   chisq: Pearson chi-square
   g_squared: likelihood ratio G^2
   df: degrees of freedom
}
\description{
The model has simple closed form solutions when fitting either the unconstrained
version of the version that species equality of delta parameters.  However,
I could not see how to adapt that to the case where specific parameters were
constrained to have a specific value.  This routine is to fit that model. It will
also fit the unconstrained model, but Goodman gives the estimator for that case.
}
\examples{
fixed <- c(FALSE, TRUE, FALSE)
delta <- c(1.0, 1.0, 1.0)
phi <- matrix(0.0, nrow=4, ncol=4)
diag(phi) = rep(1.0, 4)
Goodman_fixed_parameter(vision_data, delta, fixed)
}
\seealso{
[Goodman_diagonals_parameter_symmetry()]

[Goodman_ml()]
}
