test_that("McCullagh_logistic_get_statistics", {
  m <- coal_g
  result <- McCullagh_get_statistics(m)
  N <- result$N
  n <- result$n
  r <- result$r
  expected_N <- matrix(c(14, 4, 0,
                         4, 12, 3,
                         0, 3, 6), nrow=3, byrow=TRUE)
  expect_equal(expected_N, N)
  expected_n <- c(14, 12, 6)
  expect_equal(expected_n, n)
  expected_r <- c(11, 11, 5)
  expect_equal(expected_r, r)
}
)


test_that("McCullagh_logistic_model", {
  m <- coal_g
  result <- McCullagh_logistic_model(m)
  w_tilde <- result$w_tilde
  w_star <- result$w_star
  delta_tilde <- result$delta_tilde
  delta_star <- result$delta_star
  sd <- sqrt(result$var)

  expect_true(abs(w_tilde[1] - 0.523) < 0.0005, info=paste("w_tilde", 1, w_tilde[1]))
  expect_true(abs(w_tilde[2] - 0.283) < 0.0005, info=paste("w_tilde", 2, w_tilde[2]))
  expect_true(abs(w_tilde[3] - 0.194) < 0.0005, info=paste("w_tilde", 3, w_tilde[3]))

  expect_true(abs(w_star[1] - 0.847) < 0.0005, info=paste("w_star", 1, w_star[1]))
  expect_true(abs(w_star[2] - 0.534) < 0.0005, info=paste("w_star", 2, w_star[2]))
  expect_true(abs(w_star[3] - 0.733) < 0.0005, info=paste("w_star", 3, w_star[3]))

  expect_true(abs(delta_tilde - 1.450) < 0.0005, info=paste("w_tilde", 1.450, w_tilde[1]))
  expect_true(abs(delta_star - 1.503) < 0.0005, info=paste("w_star", 1.503, w_star[1]))

  expect_true(abs(sd - 0.53) <= 0.005, info=paste("sd", 0.53, sd))
}
)


test_that("McCullagh_logistic_model_singular_N", {
  m <- coal_g
  stats <- McCullagh_get_statistics(m)
  N <- stats$N
  n <- stats$n
  r <- stats$r
  p <- nrow(N)
  # make N singular
  for (k in 1:p) {
    N[k, p] <- N[k, p - 1]
  }
  expect_true(!is_invertible(N), info="N should not be invertible")

  weights <- McCullagh_compute_logistic_weights(N, n)
  w_tilde <- weights$w_tilde
  w_star <- weights$w_star
  D <- diag(n)
  D_inverse <- solve(D)
  n_hat <- N %*% t(w_star)

  for (j in 1:p) {
    w_tilde[j] <- w_tilde[j] * 0.2 * (n[j] / n_hat[j])
    w_star[j] <- w_star[j] + 0.05 * (n[j] - n_hat[j])
  }

  result <- McCullagh_logistic_model(m)
  w_tilde <- result$w_tilde
  w_star <- result$w_star
  delta_tilde <- result$delta_tilde
  delta_star <- result$delta_star
  sd <- sqrt(result$var)

  expect_true(abs(w_tilde[1] - 0.523) < 0.0005, info=paste("w_tilde", 1, w_tilde[1]))
  expect_true(abs(w_tilde[2] - 0.283) < 0.0005, info=paste("w_tilde", 2, w_tilde[2]))
  expect_true(abs(w_tilde[3] - 0.194) < 0.0005, info=paste("w_tilde", 3, w_tilde[3]))

  expect_true(abs(w_star[1] - 0.847) < 0.0005, info=paste("w_star", 1, w_star[1]))
  expect_true(abs(w_star[2] - 0.534) < 0.0005, info=paste("w_star", 2, w_star[2]))
  expect_true(abs(w_star[3] - 0.733) < 0.0005, info=paste("w_star", 3, w_star[3]))

  expect_true(abs(delta_tilde - 1.450) < 0.0005, info=paste("w_tilde", 1.450, w_tilde[1]))
  expect_true(abs(delta_star - 1.503) < 0.0005, info=paste("w_star", 1.503, w_star[1]))

  expect_true(abs(sd - 0.53) <= 0.005, info=paste("sd", 0.53, sd))
}
)
