% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plm.R
\name{plm}
\alias{plm}
\title{Profile Boosting for Linear Models.}
\usage{
plm(
  formula,
  data,
  subset,
  weights,
  na.action,
  method = "qr",
  model = TRUE,
  x = FALSE,
  y = FALSE,
  qr = TRUE,
  singular.ok = TRUE,
  contrasts = NULL,
  offset,
  ...,
  stopFun = EBIC,
  keep = NULL,
  maxK = NULL,
  verbose = FALSE
)
}
\arguments{
\item{formula}{See \link{pboost}.}

\item{data}{See \link{pboost}.}

\item{subset}{Parameters passed to \link{lm}.}

\item{weights}{Parameters passed to \link{lm}.}

\item{na.action}{Parameters passed to \link{lm}.}

\item{method}{Parameters passed to \link{lm}.}

\item{model}{Parameters passed to \link{lm}.}

\item{x}{Parameters passed to \link{lm}.}

\item{y}{Parameters passed to \link{lm}.}

\item{qr}{Parameters passed to \link{lm}.}

\item{singular.ok}{Parameters passed to \link{lm}.}

\item{contrasts}{Parameters passed to \link{lm}.}

\item{offset}{Parameters passed to \link{lm}.}

\item{...}{Parameters passed to \link{lm}.}

\item{stopFun}{Parameters passed to \link{pboost}.}

\item{keep}{Parameters passed to \link{pboost}.}

\item{maxK}{Parameters passed to \link{pboost}.}

\item{verbose}{Parameters passed to \link{pboost}.}
}
\value{
An \code{lm} model object fitted on the selected features.
}
\description{
\link{plm} inherits the usage of the built-in function \link{lm}.
}
\details{
\code{plm} is an equivalent implementation to the sequential lasso method
proposed by Luo and Chen(2014, \doi{10.1080/01621459.2013.877275}).
}
\examples{
set.seed(2025)
n <- 300
p <- 200
x <- matrix(rnorm(n*p), n)

eta <- drop( x[, 1:3] \%*\% runif(3, 1.0, 1.5) )
y <- eta + rnorm(n, sd=sd(eta))
DF <- data.frame(y, x)

plm(y ~ ., DF, verbose=TRUE)
plm(y ~ ., DF, stopFun=BIC, verbose=TRUE)
pboost(y ~ ., DF, lm, residuals, EBIC, verbose=TRUE)

}
\references{
\itemize{
\item Zengchao Xu, Shan Luo and Zehua Chen (2022). Partial profile score feature
selection in high-dimensional generalized linear interaction models.
Statistics and Its Interface. \doi{10.4310/21-SII706}
\item Shan Luo and Zehua Chen (2014). A Sequential Lasso Method for Feature Selection
with Ultra-High Dimensional Feature Space. Journal of the American Statistical
Association, 109(507):223–232. \doi{10.1080/01621459.2013.877275}
}
}
